/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup.standalone;

import com.exasol.exasoltestsetup.standalone.Credentials;
import java.nio.file.Path;
import java.util.Objects;

public class ConnectionDetails {
    private final String managementNodeAddress;
    private final String dataNodeAddress;
    private final Credentials databaseCredentials;
    private final Credentials adminCredentials;
    private final int sshPort;
    private final Path pathToSshKey;

    private ConnectionDetails(Builder builder) {
        this.managementNodeAddress = builder.managementNodeAddress;
        this.dataNodeAddress = builder.dataNodeAddress;
        this.databaseCredentials = builder.databaseCredentials;
        this.adminCredentials = builder.adminCredentials;
        this.sshPort = builder.sshPort;
        this.pathToSshKey = builder.pathToSshKey;
    }

    public String getManagementNodeAddress() {
        return this.managementNodeAddress;
    }

    public String getDataNodeAddress() {
        return this.dataNodeAddress;
    }

    public Credentials getDatabaseCredentials() {
        return this.databaseCredentials;
    }

    public Credentials getAdminCredentials() {
        return this.adminCredentials;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public Path getPathToSshKey() {
        return this.pathToSshKey;
    }

    public String toString() {
        return "ConnectionDetails [managementNodeAddress=" + this.managementNodeAddress + ", dataNodeAddress=" + this.dataNodeAddress + ", databaseCredentials=" + this.databaseCredentials + ", adminCredentials=" + this.adminCredentials + ", sshPort=" + this.sshPort + ", pathToSshKey=" + this.pathToSshKey + "]";
    }

    public int hashCode() {
        return Objects.hash(this.adminCredentials, this.dataNodeAddress, this.databaseCredentials, this.managementNodeAddress, this.pathToSshKey, this.sshPort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails)obj;
        return Objects.equals(this.adminCredentials, other.adminCredentials) && Objects.equals(this.dataNodeAddress, other.dataNodeAddress) && Objects.equals(this.databaseCredentials, other.databaseCredentials) && Objects.equals(this.managementNodeAddress, other.managementNodeAddress) && Objects.equals(this.pathToSshKey, other.pathToSshKey) && this.sshPort == other.sshPort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String managementNodeAddress;
        private String dataNodeAddress;
        private Credentials databaseCredentials;
        private Credentials adminCredentials;
        private int sshPort;
        private Path pathToSshKey;

        private Builder() {
        }

        public Builder managementNodeAddress(String managementNodeAddress) {
            this.managementNodeAddress = managementNodeAddress;
            return this;
        }

        public Builder dataNodeAddress(String dataNodeAddress) {
            this.dataNodeAddress = dataNodeAddress;
            return this;
        }

        public Builder databaseCredentials(Credentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
            return this;
        }

        public Builder adminCredentials(Credentials adminCredentials) {
            this.adminCredentials = adminCredentials;
            return this;
        }

        public Builder sshPort(int sshPort) {
            this.sshPort = sshPort;
            return this;
        }

        public Builder pathToSshKey(Path pathToSshKey) {
            this.pathToSshKey = pathToSshKey;
            return this;
        }

        public ConnectionDetails build() {
            return new ConnectionDetails(this);
        }
    }
}

