/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup.standalone;

import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.WaitHelper;
import com.exasol.exasoltestsetup.standalone.Credentials;
import de.timroes.axmlrpc.XMLRPCClient;
import de.timroes.axmlrpc.XMLRPCException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.IOUtils;

class ExaOperationGateway {
    private static final Logger LOGGER = Logger.getLogger(ExaOperationGateway.class.getName());
    private final XMLRPCClient client;

    public ExaOperationGateway(String exasolIpAddress, Credentials credentials) {
        try {
            URL serverUrl = new URL("https://" + exasolIpAddress + "/cluster1");
            this.client = new XMLRPCClient(serverUrl, 192);
            this.client.setLoginData(credentials.getUsername(), credentials.getPassword());
        }
        catch (MalformedURLException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-1").message("Failed to connect to the ExaOperation XML-RPC interface.", new Object[0]).toString(), exception);
        }
    }

    public void startStorageServiceIfNotRunning() {
        if (!this.isStorageServiceRunning()) {
            this.startStorageService();
        }
    }

    private void startStorageService() {
        try {
            LOGGER.info("Starting exasol storage service via ExaOperation.");
            this.client.call("storage.startEXAStorage", new Object[0]);
            WaitHelper.waitUntil(this::isStorageServiceRunning, 60, "starting storage service");
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-7").message("Failed to start exasol storage service.", new Object[0]).toString(), exception);
        }
    }

    private boolean isStorageServiceRunning() {
        try {
            return (Boolean)this.client.call("storage.serviceIsOnline", new Object[0]);
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-14").message("Failed to test if exasol storage service is running.", new Object[0]).toString(), exception);
        }
    }

    public void startAllDatabases() {
        this.listDatabases().forEach(this::startDatabaseIfNotRunning);
    }

    public List<String> listDatabases() {
        try {
            Object[] result = (Object[])this.client.call("getDatabaseList", new Object[0]);
            return Arrays.stream(result).map(String.class::cast).collect(Collectors.toList());
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-8").message("Failed list exasol databases.", new Object[0]).toString(), exception);
        }
    }

    public void startDatabaseIfNotRunning(String databaseName) {
        if (!this.isDatabaseRunning(databaseName)) {
            this.startDatabase(databaseName);
        }
    }

    private void startDatabase(String databaseName) {
        try {
            LOGGER.log(Level.INFO, "Starting exasol database {0} via ExaOperation.", databaseName);
            this.client.call("db_" + databaseName + ".startDatabase", new Object[0]);
            WaitHelper.waitUntil(() -> this.isDatabaseRunning(databaseName), 60, "starting database");
            WaitHelper.waitFor(1000L);
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-9").message("Failed to start exasol databases.", new Object[0]).toString(), exception);
        }
    }

    private boolean isDatabaseRunning(String databaseName) {
        try {
            return (Boolean)this.client.call("db_" + databaseName + ".runningDatabase", new Object[0]);
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-10").message("Failed to test if database is running.", new Object[0]).toString(), exception);
        }
    }

    public void setBucketFsPort(String bucketFsName, int port) {
        try {
            this.client.call(bucketFsName + ".editBucketFS", new Object[]{Map.of("http_port", port)});
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-2").message("Failed to set BucketFS port in ExaOperation.", new Object[0]).toString(), exception);
        }
    }

    public void setBucketPasswords(String readPassword, String writePassword) {
        try {
            this.client.call("bfsdefault.default.editBucketFSBucket", new Object[]{Map.of("read_password", readPassword, "write_password", writePassword)});
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-3").message("Failed to set BucketFS password in ExaOperation.", new Object[0]).toString(), exception);
        }
    }

    public void createAndUploadJdbcDriver(String name, String jdbcMainClass, String prefix, boolean disableSecurityManager, File driverJar) throws IOException {
        String driverId = this.addJdbcDriver(name, jdbcMainClass, prefix, disableSecurityManager);
        this.uploadJdbcDriver(driverId, driverJar);
    }

    private String addJdbcDriver(String name, String jdbcMainClass, String prefix, boolean disableSecurityManager) {
        try {
            return (String)this.client.call("addJDBCDriver", new Object[]{Map.of("jdbc_main", jdbcMainClass, "jdbc_name", name, "jdbc_prefix", prefix, "disable_security_manager", disableSecurityManager)});
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-4").message("Failed to add JDBC driver using ExaOperation.", new Object[0]).toString(), exception);
        }
    }

    private void uploadJdbcDriver(String jdbcDriverId, File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] driverBytes = IOUtils.toByteArray((InputStream)inputStream);
            this.client.call(jdbcDriverId + ".uploadFile", new Object[]{driverBytes, file.getName()});
        }
        catch (XMLRPCException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-5").message("Failed to upload JDBC driver using ExaOperation.", new Object[0]).toString(), exception);
        }
    }
}

