/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup.standalone;

import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.standalone.ConnectionDetails;
import com.exasol.exasoltestsetup.standalone.Credentials;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;

public class JsonConnectionDetailsReader {
    private static final int DEFAULT_SSH_PORT = 22;

    public ConnectionDetails read(Path configFile) {
        JsonObject jsonConfig = this.readJsonConfig(configFile);
        return this.readDetails(configFile, jsonConfig);
    }

    ConnectionDetails readDetails(Path configFile, JsonObject jsonConfig) {
        return ConnectionDetails.builder().dataNodeAddress(this.readRequiredAttribute(jsonConfig, "dataNodeAddress", configFile)).managementNodeAddress(this.readRequiredAttribute(jsonConfig, "managementNodeAddress", configFile)).sshPort(jsonConfig.getInt("sshPort", 22)).pathToSshKey(Path.of(this.readRequiredAttribute(jsonConfig, "sshKey", configFile), new String[0])).databaseCredentials(new Credentials(this.readRequiredAttribute(jsonConfig, "sqlUser", configFile), this.readRequiredAttribute(jsonConfig, "sqlPass", configFile))).adminCredentials(new Credentials(this.readRequiredAttribute(jsonConfig, "adminUser", configFile), this.readRequiredAttribute(jsonConfig, "adminPass", configFile))).build();
    }

    private String readRequiredAttribute(JsonObject jsonConfig, String attribute, Path fileName) {
        String attributeValue = jsonConfig.getString(attribute, null);
        if (attributeValue == null) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-34").message("Missing attribute {{attribute}} in test-config-file {{file}}.", new Object[]{attribute, fileName}).toString());
        }
        return attributeValue;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonObject readJsonConfig(Path configFile) {
        try (FileReader fileReader = new FileReader(configFile.toFile());){
            JsonObject jsonObject;
            block13: {
                JsonReader jsonReader = Json.createReader((Reader)fileReader);
                try {
                    jsonObject = jsonReader.readObject();
                    if (jsonReader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return jsonObject;
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder((String)"E-ETAJ-33").message("Failed to open test-config file {{config file}}.", new Object[]{configFile}).toString(), exception);
        }
    }
}

