/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup.standalone;

import com.exasol.bucketfs.Bucket;
import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.SyncAwareBucket;
import com.exasol.bucketfs.WriteEnabledBucket;
import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.bucketfs.monitor.TimestampRetriever;
import com.exasol.dbcleaner.ExasolDatabaseCleaner;
import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.ExasolTestSetup;
import com.exasol.exasoltestsetup.PasswordGenerator;
import com.exasol.exasoltestsetup.SessionBuilder;
import com.exasol.exasoltestsetup.SqlConnectionInfo;
import com.exasol.exasoltestsetup.SshConnection;
import com.exasol.exasoltestsetup.WaitHelper;
import com.exasol.exasoltestsetup.identity.IdentityProvider;
import com.exasol.exasoltestsetup.standalone.ConnectionDetails;
import com.exasol.exasoltestsetup.standalone.ExaOperationGateway;
import com.exasol.exasoltestsetup.standalone.WaitBucketFsMonitor;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class StandaloneExasolTestSetup
implements ExasolTestSetup {
    private static final Logger LOGGER = Logger.getLogger(StandaloneExasolTestSetup.class.getName());
    private static final int BUCKET_FS_PORT = 2580;
    private static final int DATABASE_PORT = 8563;
    private static final int EXA_OPERATION_PORT = 443;
    private final ConnectionDetails connectionDetails;
    private final String bucketFsReadPassword;
    private final String bucketFsWritePassword;
    private final SshConnection sshConnection;
    private final int localBucketFsPort;
    private final int localDatabasePort;
    private final List<String> dataNodeIds;

    public StandaloneExasolTestSetup(ConnectionDetails connectionDetails) {
        this.connectionDetails = connectionDetails;
        this.sshConnection = this.createConfiguredSshConnection();
        this.dataNodeIds = this.fetchDataNodeIds();
        this.localBucketFsPort = this.sshConnection.addForwardPortForwarding(2580, this.getADataNode());
        int localHttpsPort = this.sshConnection.addForwardPortForwarding(443);
        this.localDatabasePort = this.sshConnection.addForwardPortForwarding(8563, this.getADataNode());
        ExaOperationGateway exaOperationGateway = new ExaOperationGateway("localhost:" + localHttpsPort, connectionDetails.getAdminCredentials());
        exaOperationGateway.startStorageServiceIfNotRunning();
        exaOperationGateway.startAllDatabases();
        exaOperationGateway.setBucketFsPort("bfsdefault", 2580);
        this.bucketFsReadPassword = PasswordGenerator.generatePassword();
        this.bucketFsWritePassword = PasswordGenerator.generatePassword();
        this.setBucketsPasswordWithWorkaround(exaOperationGateway);
        WaitHelper.waitUntil(this::isSqlInterfaceAvailable, 120, "SQL interface");
        this.cleanTheDatabase();
    }

    private void setBucketsPasswordWithWorkaround(ExaOperationGateway exaOperationGateway) {
        int tryCounter = 0;
        do {
            exaOperationGateway.setBucketPasswords(this.bucketFsReadPassword, this.bucketFsWritePassword);
            WaitHelper.waitFor(100L);
            if (++tryCounter <= 10) continue;
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-32").message("Failed to set BucketFS password.", new Object[0]).toString());
        } while (!this.isBucketFsAvailable());
    }

    private boolean isBucketFsAvailable() {
        String testFile = "bfs-test-" + System.currentTimeMillis() + ".txt";
        Bucket bucket = this.getDefaultBucket();
        try {
            bucket.uploadStringContent("1", testFile);
            bucket.downloadFileAsString(testFile);
            bucket.deleteFileNonBlocking(testFile);
            return true;
        }
        catch (BucketAccessException | TimeoutException exception) {
            return false;
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-30").message("Interrupt which checking BucketFs connection.", new Object[0]).toString(), exception);
        }
    }

    private String getADataNode() {
        if (this.dataNodeIds.isEmpty()) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-27").message("No datanodes available.", new Object[0]).mitigation("Probably the cluster has not started completely. Try to wait a bit.", new Object[0]).toString());
        }
        return this.dataNodeIds.get(0);
    }

    private List<String> fetchDataNodeIds() {
        ArrayList<String> nodes = new ArrayList<String>(Arrays.asList(this.sshConnection.runCommand("/usr/opt/EXASuite-*/EXAClusterOS-*/bin/cosinfo -e").whenFinished().assertExitCodeIsZero().getStdout().split("\n")));
        nodes.removeIf(nodeId -> nodeId.equals("10"));
        return nodes.stream().map(id -> "n" + id).collect(Collectors.toList());
    }

    private SshConnection createConfiguredSshConnection() {
        return this.addGatewayPortsIfRequired(this.createSshConnection());
    }

    private SshConnection createSshConnection() {
        return new SshConnection(this.sessionBuilder());
    }

    private SshConnection addGatewayPortsIfRequired(SshConnection connection) {
        String sshConfig = connection.runCommandAsRoot("cat /etc/ssh/sshd_config").whenFinished().assertExitCodeIsZero().getStdout();
        if (!sshConfig.contains("GatewayPorts yes")) {
            LOGGER.warning(() -> ExaError.messageBuilder((String)"W-ETAJ-21").message("The management nodes ssh configuration did not contain GatewayPorts yes. We will now automatically add it.", new Object[0]).toString());
            connection.runCommandAsRoot("echo GatewayPorts yes >> /etc/ssh/sshd_config");
            try {
                connection.runCommandAsRoot("killall -s HUP sshd");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            connection.close();
            WaitHelper.waitFor(5000L);
            connection = this.createSshConnection();
        }
        return connection;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isSqlInterfaceAvailable() {
        try (Connection connection = this.createConnection();){
            boolean bl;
            block14: {
                Statement statement = connection.createStatement();
                try {
                    statement.executeQuery("SELECT * FROM DUAL;");
                    bl = true;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException exception) {
            return false;
        }
    }

    private void cleanTheDatabase() {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            new ExasolDatabaseCleaner(statement).cleanDatabase();
        }
        catch (SQLException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-ETAJ-28").message("Failed to connect to the exasol database for cleaning.", new Object[0]).toString(), exception);
        }
    }

    @Override
    public Connection createConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:exa:localhost:" + this.localDatabasePort + ";validateservercertificate=0", this.connectionDetails.getDatabaseCredentials().getUsername(), this.connectionDetails.getDatabaseCredentials().getPassword());
    }

    @Override
    public SqlConnectionInfo getConnectionInfo() {
        return new SqlConnectionInfo("localhost", this.localDatabasePort, this.connectionDetails.getDatabaseCredentials().getUsername(), this.connectionDetails.getDatabaseCredentials().getPassword());
    }

    @Override
    public Bucket getDefaultBucket() {
        return ((SyncAwareBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)SyncAwareBucket.builder().host("localhost")).port(this.localBucketFsPort)).name("default")).serviceName("bfsdefault")).readPassword(this.bucketFsReadPassword)).writePassword(this.bucketFsWritePassword)).monitor((BucketFsMonitor)new WaitBucketFsMonitor()).stateRetriever((BucketFsMonitor.StateRetriever)new TimestampRetriever()).build();
    }

    @Override
    public InetSocketAddress makeLocalTcpServiceAccessibleFromDatabase(int localPort) {
        int remotePort = this.sshConnection.addReversePortForwarding(localPort);
        return new InetSocketAddress("license", remotePort);
    }

    @Override
    public List<Integer> makeDatabaseTcpServiceAccessibleFromLocalhost(int databasePort) {
        return this.dataNodeIds.stream().map(dataNodeId -> this.sshConnection.addForwardPortForwarding(databasePort, (String)dataNodeId)).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.sshConnection.close();
    }

    private SessionBuilder sessionBuilder() {
        return new SessionBuilder().user("ec2-user").host(this.connectionDetails.getManagementNodeAddress()).port(this.connectionDetails.getSshPort()).identity(IdentityProvider.fromPathToPrivateKey("./cloudSetup/generated/exasol_cluster_ssh_key"));
    }
}

