/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exasoltestsetup.testcontainers;

import com.exasol.bucketfs.Bucket;
import com.exasol.containers.ExasolContainer;
import com.exasol.errorreporting.ExaError;
import com.exasol.exasoltestsetup.ExasolTestSetup;
import com.exasol.exasoltestsetup.SessionBuilder;
import com.exasol.exasoltestsetup.SqlConnectionInfo;
import com.exasol.exasoltestsetup.SshConnection;
import com.exasol.exasoltestsetup.identity.IdentityProvider;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import org.testcontainers.containers.Container;

public class ExasolTestcontainerTestSetup
implements ExasolTestSetup {
    private static final int SSH_PORT = 22;
    private final ExasolContainer<? extends ExasolContainer<?>> exasolContainer = new ExasolContainer("7.1.19").withReuse(true);
    private final SshConnection sshConnection;
    private final KeyPair keyPair;

    public ExasolTestcontainerTestSetup() {
        this.exasolContainer.addExposedPort(Integer.valueOf(22));
        this.exasolContainer.start();
        try {
            this.keyPair = KeyPair.genKeyPair((JSch)new JSch(), (int)2);
        }
        catch (JSchException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETAJ-36").message("Failed to generate temporary ssh-key.", new Object[0]).ticketMitigation().toString(), exception);
        }
        this.installSshKeyInDatabase();
        this.sshConnection = new SshConnection(this.sessionBuilder());
    }

    @Override
    public Connection createConnection() throws SQLException {
        return this.exasolContainer.createConnection();
    }

    @Override
    public SqlConnectionInfo getConnectionInfo() {
        return new SqlConnectionInfo(this.exasolContainer.getHost(), this.exasolContainer.getFirstMappedDatabasePort(), this.exasolContainer.getUsername(), this.exasolContainer.getPassword());
    }

    @Override
    public Bucket getDefaultBucket() {
        return this.exasolContainer.getDefaultBucket();
    }

    @Override
    public InetSocketAddress makeLocalTcpServiceAccessibleFromDatabase(int localPort) {
        int remotePort = this.sshConnection.addReversePortForwarding(localPort);
        return new InetSocketAddress("localhost", remotePort);
    }

    @Override
    public List<Integer> makeDatabaseTcpServiceAccessibleFromLocalhost(int databasePort) {
        int localPort = this.sshConnection.addForwardPortForwarding(databasePort);
        return List.of(Integer.valueOf(localPort));
    }

    private void installSshKeyInDatabase() {
        try {
            this.runInContainerWithCheck("bash", "-c", "echo \"ssh-rsa " + Base64.getEncoder().encodeToString(this.keyPair.getPublicKeyBlob()) + "\" >> /root/.ssh/authorized_keys");
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-ETAJ-16").message("Failed to upload ssh-public-key to container. This is required for login in via SSH.", new Object[0]).ticketMitigation().toString(), exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
        }
    }

    private void runInContainerWithCheck(String ... commands) throws IOException, InterruptedException {
        Container.ExecResult execResult = this.exasolContainer.execInContainer(commands);
        if (execResult.getExitCode() != 0) {
            throw new IOException(ExaError.messageBuilder((String)"F-ETAJ-17").message("Failed to exit exaconf in container. The program had an exit code != 0. Error message:\n {{message|uq}}", new Object[]{execResult.getStderr()}).toString());
        }
    }

    @Override
    public void close() throws Exception {
        this.sshConnection.close();
        this.exasolContainer.stop();
    }

    private SessionBuilder sessionBuilder() {
        ByteArrayOutputStream privateKey = new ByteArrayOutputStream();
        this.keyPair.writePrivateKey((OutputStream)privateKey);
        return new SessionBuilder().user("root").host(this.exasolContainer.getHost()).port(this.exasolContainer.getMappedPort(22)).identity(IdentityProvider.builder().identityName("tmp-key").publicKey(this.keyPair.getPublicKeyBlob()).privateKey(privateKey.toByteArray()).build());
    }
}

