/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper;

import com.exasol.errorreporting.ExaError;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BrokenLinkReplacer {
    private static final String JACOCO_HOMEPAGE = "https://www.eclemma.org/jacoco/index.html";
    private static final Map<String, String> BUILTIN_REPLACEMENTS_1 = Map.of("http://org.jacoco.agent", "https://www.eclemma.org/jacoco/index.html", "http://org.jacoco.core", "https://www.eclemma.org/jacoco/index.html", "http://jacoco-maven-plugin", "https://www.eclemma.org/jacoco/index.html", "https://eclipse-ee4j.github.io/jaxb-ri/jaxb-runtime-parent/jaxb-runtime", "https://eclipse-ee4j.github.io/jaxb-ri/", "https://www.eclipse.org/jgit//org.eclipse.jgit", "https://www.eclipse.org/jgit/", "http://maven.apache.org/maven-project", "http://maven.apache.org/", "https://sonatype.github.io/ossindex-maven/ossindex-maven-plugin/", "https://sonatype.github.io/ossindex-maven/maven-plugin/", "https://github.com/javaee/jaxb-spec/jaxb-api", "https://github.com/eclipse-ee4j/jaxb-api", "https://github.com/exasol/error-code-crawler-maven-plugint", "https://github.com/exasol/error-code-crawler-maven-plugin", "https://github.com/eclipse-ee4j/parsson/parsson", "https://github.com/eclipse-ee4j/parsson");
    private static final Map<String, String> BUILTIN_REPLACEMENTS_2 = Map.of("https://www.mojohaus.org/flatten-maven-plugin/flatten-maven-plugin", "https://www.mojohaus.org/flatten-maven-plugin/", "https://awhitford.github.com/lombok.maven/lombok-maven-plugin/", "https://anthonywhitford.com/lombok.maven/lombok-maven-plugin/", "LICENSE-exasol-jdbc.txt", "https://docs.exasol.com/connect_exasol/drivers/jdbc.htm");
    private final Map<String, String> replacements = new HashMap<String, String>(BrokenLinkReplacer.getBuiltinReplacements());

    private static Map<String, String> getBuiltinReplacements() {
        HashMap<String, String> builtinReplacements = new HashMap<String, String>();
        builtinReplacements.putAll(BUILTIN_REPLACEMENTS_1);
        builtinReplacements.putAll(BUILTIN_REPLACEMENTS_2);
        return BrokenLinkReplacer.convertKeysToLowerCase(builtinReplacements);
    }

    private static Map<String, String> convertKeysToLowerCase(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
    }

    public BrokenLinkReplacer(List<String> replacementParameters) {
        this.readReplacementParameter(replacementParameters);
    }

    private void readReplacementParameter(List<String> replacementParameters) {
        for (String replacementParameter : replacementParameters) {
            String[] parts = replacementParameter.split("\\|");
            this.checkSyntax(replacementParameter, parts);
            this.replacements.put(parts[0].toLowerCase().trim(), parts[1].trim());
        }
    }

    private void checkSyntax(String replacementParameter, String[] parts) {
        if (parts.length != 2) {
            throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-55").message("Invalid link replacement {{link replacement}}. ", replacementParameter).message("The link replacement should have the syntax '<linkReplacement>originalLink|replacement</linkReplacement>'.", new Object[0]).mitigation("Change the linkReplacement in you pom.xml file.", new Object[0]).toString());
        }
    }

    public String replaceIfBroken(String originalLink) {
        if (originalLink == null) {
            return null;
        }
        return this.replacements.getOrDefault(originalLink.toLowerCase(), originalLink);
    }
}

