/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper;

import com.exasol.projectkeeper.shared.mavenprojectcrawler.MavenProjectCrawlResult;
import com.exasol.projectkeeper.shared.mavenprojectcrawler.ResponseCoder;
import com.exasol.projectkeeper.sources.analyze.generic.CommandExecutor;
import com.exasol.projectkeeper.sources.analyze.generic.MavenProcessBuilder;
import com.exasol.projectkeeper.sources.analyze.generic.ProcessResult;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.stream.Collectors;

public class JavaProjectCrawlerRunner {
    private final Path mvnRepositoryOverride;
    private final String ownVersion;

    public JavaProjectCrawlerRunner(Path mvnRepositoryOverride, String ownVersion) {
        this.mvnRepositoryOverride = mvnRepositoryOverride;
        this.ownVersion = ownVersion;
    }

    public MavenProjectCrawlResult crawlProject(Path ... pomFiles) {
        String json = this.runCrawlerPlugin(pomFiles);
        return MavenProjectCrawlResult.fromJson(json);
    }

    private String runCrawlerPlugin(Path ... pomFiles) {
        MavenProcessBuilder builder = this.buildMavenCommand(pomFiles);
        ProcessResult result = new CommandExecutor().execute(builder.buildCommand());
        return new ResponseCoder().decodeResponse(result.getOutputStreamContent());
    }

    private MavenProcessBuilder buildMavenCommand(Path ... pomFiles) {
        MavenProcessBuilder builder = MavenProcessBuilder.create().addArguments("-Dorg.slf4j.simpleLogger.log.org.apache.maven.cli.transfer.Slf4jMavenTransferListener=warn", "com.exasol:project-keeper-java-project-crawler:" + this.ownVersion + ":crawl", "-DprojectsToCrawl=" + this.getProjectList(pomFiles), "-Dmaven.defaultProjectBuilder.disableGlobalModelCache=true").workingDir(null).timeout(Duration.ofSeconds(90L));
        if (this.mvnRepositoryOverride != null) {
            builder.addArgument("-Dmaven.repo.local=" + this.mvnRepositoryOverride);
        }
        return builder;
    }

    private String getProjectList(Path ... pomFiles) {
        return Arrays.stream(pomFiles).map(this::formatPath).collect(Collectors.joining(";"));
    }

    private String formatPath(Path pomFile) {
        return pomFile.toAbsolutePath().toString().replace(FileSystems.getDefault().getSeparator(), "/");
    }
}

