/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper;

import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class LicenseNameReader {
    public String readLicenseName(Path projectDir) {
        String licenseFile = this.readLicenseFile(projectDir);
        return this.getFirstLine(licenseFile);
    }

    private String getFirstLine(String licenseFile) {
        return licenseFile.split("\n")[0].trim();
    }

    private String readLicenseFile(Path projectDir) {
        try {
            return Files.readString(projectDir.resolve("LICENSE"));
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-124").message("Failed to read LICENSE file. That's strange because it should have been created by the LicenseValidator.", new Object[0]).ticketMitigation().toString(), exception);
        }
    }
}

