/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper;

import java.util.Locale;

public class OsCheck {
    public static String suffix(String suffixForWindows) {
        return OsCheck.detectOperatingSystemType() == OSType.WINDOWS ? suffixForWindows : "";
    }

    public OSType getOperatingSystemType() {
        return OsCheck.detectOperatingSystemType();
    }

    private static OSType detectOperatingSystemType() {
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.indexOf("mac") >= 0 || os.indexOf("darwin") >= 0) {
            return OSType.MACOS;
        }
        if (os.indexOf("win") >= 0) {
            return OSType.WINDOWS;
        }
        if (os.indexOf("linux") >= 0) {
            return OSType.LINUX;
        }
        return OSType.OTHER;
    }

    public static enum OSType {
        WINDOWS,
        MACOS,
        LINUX,
        OTHER;

    }
}

