/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.config.FixedVersion;
import com.exasol.projectkeeper.shared.config.ProjectKeeperConfig;
import com.exasol.projectkeeper.shared.config.VersionConfig;
import com.exasol.projectkeeper.shared.config.VersionFromSource;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class ProjectVersionDetector {
    private static final String FAILED_TO_DETECT_VERSION = "Failed to detect overall project version.";

    public String detectVersion(ProjectKeeperConfig config, List<AnalyzedSource> analyzedSources) {
        if (config.getVersionConfig() != null) {
            VersionProviderVisitor visitor = new VersionProviderVisitor(analyzedSources);
            config.getVersionConfig().accept(visitor);
            return visitor.getVersion();
        }
        if (analyzedSources.size() == 1 && analyzedSources.get(0).getVersion() != null) {
            return analyzedSources.get(0).getVersion();
        }
        throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-116").message("Failed to detect overall project version. Project-keeper can only auto-detect the project version for projects with exactly one source.", new Object[0]).mitigation("Please configure how to detect the version in your project-keeper config.", new Object[0]).toString());
    }

    private static class VersionProviderVisitor
    implements VersionConfig.Visitor {
        private final List<AnalyzedSource> analyzedSources;
        private String version;

        private VersionProviderVisitor(List<AnalyzedSource> analyzedSources) {
            this.analyzedSources = analyzedSources;
        }

        @Override
        public void visit(FixedVersion fixedVersion) {
            this.version = fixedVersion.getVersion();
        }

        @Override
        public void visit(VersionFromSource versionFromMavenSource) {
            Path requestedPath = versionFromMavenSource.getPathToPom();
            this.version = this.analyzedSources.stream().filter(source -> source.getPath().normalize().equals(requestedPath.normalize())).findAny().orElseThrow(() -> this.getNoSourceFoundException(requestedPath, this.analyzedSources)).getVersion();
            if (this.version == null) {
                throw this.getSourceHasNoVersionException(requestedPath);
            }
        }

        private IllegalArgumentException getSourceHasNoVersionException(Path requestedPath) {
            return new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-115").message("Failed to detect overall project version. The specified source with path {{path}} did not provide a version.", requestedPath).mitigation("Please specify a different source to read from or set an explicit version in your project-keeper config.", new Object[0]).toString());
        }

        private IllegalArgumentException getNoSourceFoundException(Path requestedPath, List<AnalyzedSource> analyzedSources) {
            List knownSources = analyzedSources.stream().map(AnalyzedSource::getPath).collect(Collectors.toList());
            return new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-114").message("Failed to detect overall project version. Could not find a source with specified path {{path}}.", requestedPath.toString()).mitigation("Please make sure that you defined a source with exactly the same path. The following sources are defined in the config: {{sources}}.", knownSources).toString());
        }

        public String getVersion() {
            return this.version;
        }
    }
}

