/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.cli;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Logger;
import com.exasol.projectkeeper.ProjectKeeper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class ProjectKeeperLauncher {
    private static final java.util.logging.Logger LOGGER;
    private static final String GOAL_VERIFY = "verify";
    private static final String GOAL_VERIFY_RELEASE = "verify-release";
    private static final String GOAL_FIX = "fix";
    private static final String GOAL_UPDATE_DEPENDENCIES = "update-dependencies";
    private static final Map<String, ProjectKeeperGoal> ACCEPT_GOALS;
    private final Path currentWorkingDir;

    ProjectKeeperLauncher(Path currentWorkingDir) {
        try {
            this.currentWorkingDir = currentWorkingDir.toRealPath(new LinkOption[0]);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CLI-4").message("Failed to get absolute path of current directory.", new Object[0]).toString(), exception);
        }
    }

    private static void configureLogging() {
        try (InputStream is = ProjectKeeperLauncher.class.getClassLoader().getResourceAsStream("logging.properties");){
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, ExaError.messageBuilder("W-PK-CLI-3").message("Failed to load logging configuration.", new Object[0]).ticketMitigation().toString(), exception);
        }
    }

    public static void main(String[] args) {
        ProjectKeeperLauncher launcher = new ProjectKeeperLauncher(Path.of(".", new String[0]));
        launcher.start(args);
    }

    void start(String[] args) {
        this.verifyCommandLineArguments(args);
        String goal = args[0];
        this.runProjectKeeper(goal);
    }

    private void runProjectKeeper(String goal) {
        ProjectKeeper projectKeeper = this.createProjectKeeper();
        ProjectKeeperGoal method = this.getProjectKeeperGoal(goal);
        boolean success = method.execute(projectKeeper);
        if (!success) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CLI-1").message("Failed to run project keeper {{goal}}", goal).mitigation("See log messages above for details.", new Object[0]).toString());
        }
    }

    private ProjectKeeperGoal getProjectKeeperGoal(String goal) {
        ProjectKeeperGoal failure = pk -> {
            LOGGER.warning(() -> ExaError.messageBuilder("E-PK-CLI-5").message("Goal {{goal}} not supported.", goal).mitigation("Use one of the supported goals: {{supported goals}}", ACCEPT_GOALS.keySet()).toString());
            return false;
        };
        return ACCEPT_GOALS.getOrDefault(goal, failure);
    }

    private ProjectKeeper createProjectKeeper() {
        return ProjectKeeper.createProjectKeeper(new JULLogger(), this.currentWorkingDir, null);
    }

    private void verifyCommandLineArguments(String[] args) {
        if (args == null || args.length != 1 || !GOAL_FIX.equals(args[0]) && !GOAL_VERIFY.equals(args[0]) && !GOAL_UPDATE_DEPENDENCIES.equals(args[0])) {
            throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CLI-2").message("Got no or invalid command line argument {{arguments}}.", Arrays.toString(args)).mitigation("Please only specify arguments {{supported goals}}.", ACCEPT_GOALS.keySet()).toString());
        }
    }

    static {
        ProjectKeeperLauncher.configureLogging();
        LOGGER = java.util.logging.Logger.getLogger(ProjectKeeperLauncher.class.getName());
        ACCEPT_GOALS = Map.of(GOAL_VERIFY, ProjectKeeper::verify, GOAL_VERIFY_RELEASE, ProjectKeeper::verifyRelease, GOAL_FIX, ProjectKeeper::fix, GOAL_UPDATE_DEPENDENCIES, ProjectKeeper::updateDependencies);
    }

    @FunctionalInterface
    private static interface ProjectKeeperGoal {
        public boolean execute(ProjectKeeper var1);
    }

    private static class JULLogger
    implements Logger {
        private JULLogger() {
        }

        @Override
        public void info(String message) {
            LOGGER.info(message);
        }

        @Override
        public void warn(String message) {
            LOGGER.warning(message);
        }

        @Override
        public void error(String message) {
            LOGGER.severe(message);
        }
    }
}

