/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.dependencyupdate;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.dependencyupdate.Vulnerability;
import com.exasol.projectkeeper.dependencyupdate.VulnerabilityInfoProvider;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileIO;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class ChangesFileUpdater {
    private static final Pattern ISSUE_URL_PATTERN = Pattern.compile("^https://github.com/exasol/[^/]+/issues/(\\d+)$");
    private static final String SECURITY_SECTION_HEADER = "## Security";
    private final ChangesFileIO changesFileIO;
    private final Path projectDir;
    private final VulnerabilityInfoProvider vulnerabilityInfoProvider;

    ChangesFileUpdater(VulnerabilityInfoProvider vulnerabilityInfoProvider, ChangesFileIO changesFileIO, Path projectDir) {
        this.vulnerabilityInfoProvider = vulnerabilityInfoProvider;
        this.changesFileIO = changesFileIO;
        this.projectDir = projectDir;
    }

    void updateChanges(String version) {
        List<Vulnerability> vulnerabilities = this.vulnerabilityInfoProvider.getVulnerabilities();
        if (vulnerabilities.isEmpty()) {
            return;
        }
        Path changesFilePath = this.getChangesFilePath(version);
        ChangesFile changesFile = this.changesFileIO.read(changesFilePath);
        ChangesFile updatedChanges = new Updater(changesFile, vulnerabilities).update();
        this.changesFileIO.write(updatedChanges, changesFilePath);
    }

    private Path getChangesFilePath(String version) {
        return this.projectDir.resolve(ChangesFile.getPathForVersion(version));
    }

    private static class Updater {
        private final ChangesFile changesFile;
        private final List<Vulnerability> vulnerabilities;

        private Updater(ChangesFile changesFile, List<Vulnerability> vulnerabilities) {
            this.changesFile = changesFile;
            this.vulnerabilities = vulnerabilities;
        }

        private ChangesFile update() {
            return this.changesFile.toBuilder().codeName(this.createCodeName()).summary(this.createSummary()).sections(this.createOtherSections()).build();
        }

        private String createCodeName() {
            Object codeName = this.changesFile.getCodeName() != null ? this.changesFile.getCodeName().trim() : "";
            codeName = (String)codeName + (((String)codeName).isBlank() ? "Fixed " : ", fixed ");
            if (this.vulnerabilities.size() == 1) {
                Vulnerability vulnerability = this.vulnerabilities.get(0);
                codeName = (String)codeName + "vulnerability " + vulnerability.cve() + " in " + vulnerability.coordinates();
            } else {
                codeName = (String)codeName + "vulnerabilities " + this.vulnerabilities.stream().map(Vulnerability::cve).collect(Collectors.joining(", "));
            }
            return codeName;
        }

        private ChangesFileSection createSummary() {
            return this.changesFile.getSummarySection().map(ChangesFileSection::toBuilder).orElseGet(() -> ChangesFileSection.builder("## Summary")).addLine("").addLine("This release fixes the following " + (String)(this.vulnerabilities.size() == 1 ? "vulnerability" : this.vulnerabilities.size() + " vulnerabilities") + ":").addLine("").addLines(this.vulnerabilities.stream().map(this::renderVulnerability).flatMap(Collection::stream).toList()).build();
        }

        private List<String> renderVulnerability(Vulnerability vulnerability) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("### " + vulnerability.cve() + " (" + vulnerability.cwe() + ") in dependency `" + vulnerability.coordinates() + "`");
            lines.add(vulnerability.description());
            if (vulnerability.references() != null && !vulnerability.references().isEmpty()) {
                lines.add("#### References");
                lines.addAll(vulnerability.references().stream().map(link -> "* " + link).toList());
            }
            lines.add("");
            return lines;
        }

        private List<ChangesFileSection> createOtherSections() {
            ArrayList<ChangesFileSection> sections = new ArrayList<ChangesFileSection>();
            sections.add(this.buildSecuritySection());
            sections.addAll(this.changesFile.getSections().stream().filter(section -> !section.getHeading().equals(ChangesFileUpdater.SECURITY_SECTION_HEADER)).filter(Predicate.not(this::isDefaultFeaturesSection)).toList());
            return sections;
        }

        private boolean isDefaultFeaturesSection(ChangesFileSection section) {
            if (!section.getHeading().equals("## Features")) {
                return false;
            }
            return section.getContent().stream().map(String::trim).filter(Predicate.not(String::isEmpty)).filter(line -> !line.equals("* ISSUE_NUMBER: description")).findAny().isEmpty();
        }

        private ChangesFileSection buildSecuritySection() {
            ChangesFileSection.Builder securitySectionBuilder = this.getExistingSecuritySection();
            securitySectionBuilder.addLines(this.vulnerabilities.stream().map(this::createIssueFixesEntry).toList());
            securitySectionBuilder.addLine("");
            return securitySectionBuilder.build();
        }

        private ChangesFileSection.Builder getExistingSecuritySection() {
            return this.changesFile.getSections().stream().filter(section -> section.getHeading().equals(ChangesFileUpdater.SECURITY_SECTION_HEADER)).map(ChangesFileSection::toBuilder).findFirst().orElseGet(() -> ChangesFileSection.builder(ChangesFileUpdater.SECURITY_SECTION_HEADER).addLine(""));
        }

        private String createIssueFixesEntry(Vulnerability vulnerability) {
            return "* #" + this.getIssueNumber(vulnerability.issueUrl()) + ": Fixed vulnerability " + vulnerability.cve() + " in dependency `" + vulnerability.coordinates() + "`";
        }

        private String getIssueNumber(String issueUrl) {
            Matcher matcher = ISSUE_URL_PATTERN.matcher(issueUrl);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-181").message("Issues URL {{url}} does not match expected pattern {{pattern}}.", issueUrl, ISSUE_URL_PATTERN).ticketMitigation().toString());
            }
            return matcher.group(1);
        }
    }
}

