/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.dependencyupdate;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Logger;
import com.exasol.projectkeeper.ProjectKeeper;
import com.exasol.projectkeeper.dependencyupdate.ChangesFileUpdater;
import com.exasol.projectkeeper.dependencyupdate.ProjectVersionIncrementor;
import com.exasol.projectkeeper.dependencyupdate.VulnerabilityInfoProvider;
import com.exasol.projectkeeper.shared.config.ProjectKeeperConfig;
import com.exasol.projectkeeper.sources.analyze.generic.CommandExecutor;
import com.exasol.projectkeeper.sources.analyze.generic.MavenProcessBuilder;
import com.exasol.projectkeeper.sources.analyze.generic.ShellCommand;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileIO;
import java.nio.file.Path;
import java.time.Duration;

public class DependencyUpdater {
    private static final Duration MAVEN_COMMAND_TIMEOUT = Duration.ofSeconds(60L);
    private final ProjectKeeper projectKeeper;
    private final Logger logger;
    private final Path projectDir;
    private final ProjectVersionIncrementor projectVersionIncrementor;
    private final String currentProjectVersion;
    private final ChangesFileUpdater changesFileUpdater;
    private final CommandExecutor commandExecutor;

    DependencyUpdater(ProjectKeeper projectKeeper, Logger logger, Path projectDir, String currentProjectVersion, ProjectVersionIncrementor projectVersionIncrementor, ChangesFileUpdater changesFileUpdater, CommandExecutor commandExecutor) {
        this.projectKeeper = projectKeeper;
        this.logger = logger;
        this.projectDir = projectDir;
        this.currentProjectVersion = currentProjectVersion;
        this.projectVersionIncrementor = projectVersionIncrementor;
        this.changesFileUpdater = changesFileUpdater;
        this.commandExecutor = commandExecutor;
    }

    public static DependencyUpdater create(ProjectKeeper projectKeeper, ProjectKeeperConfig config, Logger logger, Path projectDir, String currentProjectVersion) {
        return new DependencyUpdater(projectKeeper, logger, projectDir, currentProjectVersion, new ProjectVersionIncrementor(config, logger, projectDir, currentProjectVersion), new ChangesFileUpdater(new VulnerabilityInfoProvider(), new ChangesFileIO(), projectDir), new CommandExecutor());
    }

    public boolean updateDependencies() {
        String version = this.incrementProjectVersion();
        this.updateDependencyVersions();
        this.runProjectKeeperFix();
        this.changesFileUpdater.updateChanges(version);
        return true;
    }

    private String incrementProjectVersion() {
        if (this.projectVersionIncrementor.isCurrentVersionReleased()) {
            this.logger.info("Current version was already released: increment version");
            return this.projectVersionIncrementor.incrementProjectVersion();
        }
        this.logger.info("Current version was not yet released: no need to increment");
        return this.currentProjectVersion;
    }

    private void updateDependencyVersions() {
        this.runMaven("versions:use-latest-releases");
        this.runMaven("versions:update-properties");
    }

    private void runMaven(String mavenGoal) {
        ShellCommand command = MavenProcessBuilder.create().addArgument(mavenGoal).workingDir(this.projectDir).timeout(MAVEN_COMMAND_TIMEOUT).buildCommand();
        this.commandExecutor.execute(command);
    }

    private void runProjectKeeperFix() {
        this.logger.info("Running project-keeper fix...");
        if (!this.projectKeeper.fix()) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-177").message("Running project-keeper fix failed, see errors above.", new Object[0]).mitigation("Fix findings and try again.", new Object[0]).toString());
        }
    }
}

