/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.dependencyupdate;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.dependencyupdate.Vulnerability;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

class VulnerabilityInfoProvider {
    static final String SYSTEM_PROPERTY_NAME = "project-keeper:vulnerabilities";
    private final Jsonb jsonb = JsonbBuilder.newBuilder().build();

    VulnerabilityInfoProvider() {
    }

    List<Vulnerability> getVulnerabilities() {
        return this.readSystemProperty().map(this::parseVulnerabilities).orElseGet(Collections::emptyList);
    }

    private Optional<String> readSystemProperty() {
        return Optional.ofNullable(System.getProperty(SYSTEM_PROPERTY_NAME));
    }

    private List<Vulnerability> parseVulnerabilities(String jsonl) {
        return Arrays.stream(jsonl.split("\n")).map(String::trim).filter(Predicate.not(String::isEmpty)).map(this::parseSingleVulnerability).toList();
    }

    private Vulnerability parseSingleVulnerability(String json) {
        try {
            return this.jsonb.fromJson(json, Vulnerability.class);
        }
        catch (JsonbException exception) {
            throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-180").message("Error parsing vulnerability info {{json}} as JSON from system property {{system property name}}: {{cause error message|uq}}", json, SYSTEM_PROPERTY_NAME, exception.getMessage()).toString(), exception);
        }
    }
}

