/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.github;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.github.KeyValuePairFormatter;
import com.exasol.projectkeeper.github.WorkflowOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.logging.Logger;

class FileContentProvider
implements WorkflowOutput {
    private static final Logger LOG = Logger.getLogger(FileContentProvider.class.getName());
    private final KeyValuePairFormatter formatter = new KeyValuePairFormatter();
    private final Writer writer;
    private final Path outputPath;

    public FileContentProvider(Writer writer, Path outputPath) {
        this.writer = writer;
        this.outputPath = outputPath;
    }

    static WorkflowOutput create(Path outputPath) {
        LOG.info(() -> "Creating new file output publisher for path '" + outputPath + "'");
        try {
            return new FileContentProvider(Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND), outputPath);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder("E-PK-CORE-188").message("Failed to open {{output file}} for appending: {{error message}}", outputPath, exception.getMessage()).toString(), exception);
        }
    }

    @Override
    public void publish(String key, String value) {
        String content = this.formatter.format(key, value);
        LOG.finest(() -> "Publishing content '" + content + "'");
        this.write(content + "\n");
    }

    private void write(String content) {
        try {
            this.writer.write(content);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder("E-PK-CORE-189").message("Failed to write content {{content}} to file {{output file}}: {{error message}}", content, this.outputPath, exception.getMessage()).toString(), exception);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder("E-PK-CORE-187").message("Failed to close file {{output file}} after writing: {{error message}}", this.outputPath, exception.getMessage()).toString(), exception);
        }
    }
}

