/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.github;

import com.exasol.projectkeeper.github.OutputPublisherFactory;
import com.exasol.projectkeeper.github.WorkflowOutput;
import com.exasol.projectkeeper.shared.config.ProjectKeeperConfig;
import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.config.SourceType;
import com.exasol.projectkeeper.sources.AnalyzedMavenSource;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileIO;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GitHubWorkflowOutput {
    private final ProjectKeeperConfig config;
    private final Path projectDir;
    private final String projectVersion;
    private final List<AnalyzedSource> analyzedSources;
    private final OutputPublisherFactory publisherFactory;
    private final ChangesFileIO changesFileIO;

    GitHubWorkflowOutput(ProjectKeeperConfig config, Path projectDir, String projectVersion, List<AnalyzedSource> analyzedSources, OutputPublisherFactory publisherFactory, ChangesFileIO changesFileIO) {
        this.config = config;
        this.projectDir = projectDir;
        this.projectVersion = projectVersion;
        this.analyzedSources = analyzedSources;
        this.publisherFactory = publisherFactory;
        this.changesFileIO = changesFileIO;
    }

    public static GitHubWorkflowOutput create(ProjectKeeperConfig config, Path projectDir, String projectVersion, List<AnalyzedSource> analyzedSources) {
        return new GitHubWorkflowOutput(config, projectDir, projectVersion, analyzedSources, new OutputPublisherFactory(System.getenv()), new ChangesFileIO());
    }

    public void provide() {
        Optional<ChangesFile> changesFile = this.readChangesFile();
        try (WorkflowOutput publisher = this.publisherFactory.create();){
            publisher.publish("release-tag", this.getReleaseTag());
            publisher.publish("additional-release-tags", this.getAdditionalReleaseTags());
            if (changesFile.isPresent()) {
                publisher.publish("release-title", this.projectVersion + " " + changesFile.get().getCodeName());
                publisher.publish("release-notes", this.extractReleaseNotes(changesFile.get()));
            }
            publisher.publish("release-artifacts", this.getReleaseArtifacts());
        }
    }

    private String getReleaseTag() {
        String prefix = this.hasRootGoModule() ? "v" : "";
        return prefix + this.projectVersion;
    }

    private boolean hasRootGoModule() {
        return this.goModules().anyMatch(Source::isRoot);
    }

    private Stream<Source> goModules() {
        return this.config.getSources().stream().filter(source -> source.getType() == SourceType.GOLANG);
    }

    private String getAdditionalReleaseTags() {
        return this.goModules().filter(Predicate.not(Source::isRoot)).map(Source::getPath).map(Path::getParent).map(Path::toString).map(path -> path + "/v" + this.projectVersion).collect(Collectors.joining("\n"));
    }

    private String getReleaseArtifacts() {
        return Stream.of(this.sourceReleaseArtifacts(), this.errorCodeReports(), this.customArtifacts()).flatMap(Function.identity()).map(Path::toString).collect(Collectors.joining("\n"));
    }

    private Stream<Path> sourceReleaseArtifacts() {
        return this.analyzedSources.stream().filter(AnalyzedMavenSource.class::isInstance).map(AnalyzedMavenSource.class::cast).filter(source -> source.getReleaseArtifactName() != null).map(source -> source.getPath().getParent().resolve("target").resolve(source.getReleaseArtifactName()));
    }

    private Stream<Path> errorCodeReports() {
        return this.analyzedSources.stream().filter(AnalyzedMavenSource.class::isInstance).map(AnalyzedMavenSource.class::cast).filter(AnalyzedMavenSource::isRootProject).map(source -> this.projectDir.resolve("target/error_code_report.json"));
    }

    private Stream<Path> customArtifacts() {
        return this.config.getSources().stream().flatMap(this::customArtifacts);
    }

    private Stream<Path> customArtifacts(Source source) {
        Path sourcePath = this.projectDir.resolve(source.getPath()).getParent();
        return source.getReleaseArtifacts().stream().map(this::replaceVersionPlaceholder).map(sourcePath::resolve);
    }

    private Path replaceVersionPlaceholder(Path path) {
        return Path.of(path.toString().replace("${version}", this.projectVersion), new String[0]);
    }

    private String extractReleaseNotes(ChangesFile changesFile) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(changesFile.getSummarySection().map(ChangesFileSection::getContent).orElseGet(Collections::emptyList));
        for (ChangesFileSection section : changesFile.getSections()) {
            this.append(lines, section);
        }
        Optional<ChangesFileSection> dependencyChangeSection = changesFile.getDependencyChangeSection();
        if (dependencyChangeSection.isPresent()) {
            this.append(lines, dependencyChangeSection.get());
        }
        return lines.stream().collect(Collectors.joining("\n"));
    }

    private void append(List<String> lines, ChangesFileSection section) {
        lines.add(section.getHeading());
        lines.addAll(section.getContent());
    }

    private Optional<ChangesFile> readChangesFile() {
        Path file = this.projectDir.resolve(ChangesFile.getPathForVersion(this.projectVersion));
        if (Files.exists(file, new LinkOption[0])) {
            return Optional.of(this.changesFileIO.read(file));
        }
        return Optional.empty();
    }
}

