/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.pom;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.pom.MavenProjectFromFileReader;
import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;

public class DefaultMavenProjectFromFileReader
implements MavenProjectFromFileReader {
    private final ProjectBuilder mavenProjectBuilder;
    private final MavenSession session;

    public DefaultMavenProjectFromFileReader(ProjectBuilder mavenProjectBuilder, MavenSession session) {
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.session = session;
    }

    @Override
    public MavenProject readProject(File pomFile) throws MavenProjectFromFileReader.ReadFailedException {
        try {
            ProjectBuildingRequest projectBuildingRequest = this.session.getProjectBuildingRequest();
            ProjectBuildingResult build = this.mavenProjectBuilder.build(pomFile, projectBuildingRequest);
            return build.getProject();
        }
        catch (ProjectBuildingException exception) {
            throw new MavenProjectFromFileReader.ReadFailedException(ExaError.messageBuilder("E-PK-MPC-46").message("Failed to build maven model.", new Object[0]).toString(), exception);
        }
    }
}

