/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.pom;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;

public class MavenModelFromRepositoryReader {
    private final ProjectBuilder mavenProjectBuilder;
    private final RepositorySystem repositorySystem;
    private final ProjectBuildingRequest projectBuildingRequest;

    public MavenModelFromRepositoryReader(ProjectBuilder mavenProjectBuilder, MavenSession session, RepositorySystem repositorySystem) {
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.repositorySystem = repositorySystem;
        this.projectBuildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        this.projectBuildingRequest.setValidationLevel(0).setResolveDependencies(false).setProcessPlugins(false);
    }

    public Model readModel(String artifactId, String groupId, String version, List<ArtifactRepository> remoteRepositories) throws ProjectBuildingException {
        Artifact artifactDescription = this.repositorySystem.createProjectArtifact(groupId, artifactId, version);
        this.projectBuildingRequest.setRemoteRepositories(remoteRepositories);
        ProjectBuildingResult build = this.mavenProjectBuilder.build(artifactDescription, true, this.projectBuildingRequest);
        return build.getProject().getModel();
    }
}

