/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.config;

import com.exasol.projectkeeper.shared.config.workflow.CustomWorkflow;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class BuildOptions {
    private static final String DEFAULT_RUNNER_OS = "ubuntu-latest";
    private final String runnerOs;
    private final boolean freeDiskSpace;
    private final List<String> exasolDbVersions;
    private final List<CustomWorkflow> workflows;

    private BuildOptions(Builder builder) {
        this.runnerOs = Objects.requireNonNull(builder.runnerOs, "runnerOs");
        this.freeDiskSpace = builder.freeDiskSpace;
        this.exasolDbVersions = Collections.unmodifiableList(Objects.requireNonNull(builder.exasolDbVersions, "exasolDbVersions"));
        this.workflows = builder.workflows;
    }

    public String getRunnerOs() {
        return this.runnerOs;
    }

    public boolean shouldFreeDiskSpace() {
        return this.freeDiskSpace;
    }

    public List<String> getExasolDbVersions() {
        return this.exasolDbVersions;
    }

    public List<CustomWorkflow> getWorkflows() {
        return this.workflows;
    }

    public Optional<CustomWorkflow> getWorkflow(String workflowName) {
        return this.workflows.stream().filter(workflow -> workflow.getWorkflowName().equals(workflowName)).findFirst();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "BuildOptions [runnerOs=" + this.runnerOs + ", freeDiskSpace=" + this.freeDiskSpace + ", exasolDbVersions=" + this.exasolDbVersions + ", workflows=" + this.workflows + "]";
    }

    public int hashCode() {
        return Objects.hash(this.runnerOs, this.freeDiskSpace, this.exasolDbVersions, this.workflows);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildOptions other = (BuildOptions)obj;
        return Objects.equals(this.runnerOs, other.runnerOs) && this.freeDiskSpace == other.freeDiskSpace && Objects.equals(this.exasolDbVersions, other.exasolDbVersions) && Objects.equals(this.workflows, other.workflows);
    }

    public static final class Builder {
        private List<String> exasolDbVersions = Collections.emptyList();
        private boolean freeDiskSpace = false;
        private String runnerOs = "ubuntu-latest";
        private List<CustomWorkflow> workflows = Collections.emptyList();

        private Builder() {
        }

        public Builder runnerOs(String runnerOs) {
            if (runnerOs != null) {
                this.runnerOs = runnerOs;
            }
            return this;
        }

        public Builder freeDiskSpace(boolean freeDiskSpace) {
            this.freeDiskSpace = freeDiskSpace;
            return this;
        }

        public Builder exasolDbVersions(List<String> exasolDbVersions) {
            if (exasolDbVersions != null) {
                this.exasolDbVersions = exasolDbVersions;
            }
            return this;
        }

        public Builder workflows(List<CustomWorkflow> workflows) {
            if (workflows != null) {
                this.workflows = workflows;
            }
            return this;
        }

        public BuildOptions build() {
            return new BuildOptions(this);
        }
    }
}

