/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.config;

import com.exasol.projectkeeper.shared.config.BuildOptions;
import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.config.VersionConfig;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ProjectKeeperConfig {
    private final List<Source> sources;
    private final List<String> linkReplacements;
    private final List<String> excludes;
    private final VersionConfig versionConfig;
    private final BuildOptions buildOptions;

    private ProjectKeeperConfig(Builder builder) {
        this.sources = Objects.requireNonNull(builder.sources, "sources");
        this.linkReplacements = Objects.requireNonNull(builder.linkReplacements, "linkReplacements");
        this.excludes = Objects.requireNonNull(builder.excludes, "excludes");
        this.versionConfig = builder.versionConfig;
        this.buildOptions = Objects.requireNonNull(builder.buildOptions, "buildOptions");
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public List<String> getLinkReplacements() {
        return this.linkReplacements;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public VersionConfig getVersionConfig() {
        return this.versionConfig;
    }

    public BuildOptions getCiBuildConfig() {
        return this.buildOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ProjectKeeperConfig [sources=" + this.sources + ", linkReplacements=" + this.linkReplacements + ", excludes=" + this.excludes + ", versionConfig=" + this.versionConfig + ", buildOptions=" + this.buildOptions + "]";
    }

    public int hashCode() {
        return Objects.hash(this.sources, this.linkReplacements, this.excludes, this.versionConfig, this.buildOptions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectKeeperConfig other = (ProjectKeeperConfig)obj;
        return Objects.equals(this.sources, other.sources) && Objects.equals(this.linkReplacements, other.linkReplacements) && Objects.equals(this.excludes, other.excludes) && Objects.equals(this.versionConfig, other.versionConfig) && Objects.equals(this.buildOptions, other.buildOptions);
    }

    public static class Builder {
        private List<Source> sources = Collections.emptyList();
        private List<String> linkReplacements = Collections.emptyList();
        private List<String> excludes = Collections.emptyList();
        private VersionConfig versionConfig;
        private BuildOptions buildOptions = BuildOptions.builder().build();

        private Builder() {
        }

        public Builder sources(List<Source> sources) {
            this.sources = sources;
            return this;
        }

        public Builder linkReplacements(List<String> linkReplacements) {
            this.linkReplacements = linkReplacements;
            return this;
        }

        public Builder excludes(List<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        public Builder versionConfig(VersionConfig versionConfig) {
            this.versionConfig = versionConfig;
            return this;
        }

        public Builder buildOptions(BuildOptions buildOptions) {
            if (buildOptions != null) {
                this.buildOptions = buildOptions;
            }
            return this;
        }

        public ProjectKeeperConfig build() {
            return new ProjectKeeperConfig(this);
        }
    }
}

