/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.config;

import com.exasol.errorreporting.ExaError;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum ProjectKeeperModule {
    DEFAULT,
    MAVEN_CENTRAL,
    JAR_ARTIFACT,
    INTEGRATION_TESTS,
    UDF_COVERAGE,
    LOMBOK,
    NATIVE_IMAGE;


    public static ProjectKeeperModule getModuleByName(String moduleName) {
        try {
            return ProjectKeeperModule.valueOf(moduleName.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            String supportedModules = Arrays.stream(ProjectKeeperModule.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-SMC-81").message("Unknown module: {{module name}}. Please update your modules configuration in the .project-keeper.yml to use one of the supported modules: {{supported modules}}", new Object[0]).parameter("module name", moduleName).parameter("supported modules", supportedModules).toString(), exception);
        }
    }
}

