/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.config;

import com.exasol.projectkeeper.shared.config.ParentPomRef;
import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.shared.config.SourceType;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Source {
    private final Path path;
    private final SourceType type;
    private final Set<ProjectKeeperModule> modules;
    private final boolean advertise;
    private final List<Path> releaseArtifacts;
    private final ParentPomRef parentPom;

    private Source(SourceBuilder builder) {
        this.path = builder.path;
        this.type = builder.type;
        this.modules = builder.modules;
        this.advertise = builder.advertise;
        this.parentPom = builder.parentPom;
        this.releaseArtifacts = builder.releaseArtifacts;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isRoot() {
        return this.getPath().getParent() == null;
    }

    public SourceType getType() {
        return this.type;
    }

    public Set<ProjectKeeperModule> getModules() {
        return this.modules;
    }

    public boolean isAdvertised() {
        return this.advertise;
    }

    public ParentPomRef getParentPom() {
        return this.parentPom;
    }

    public List<Path> getReleaseArtifacts() {
        return this.releaseArtifacts;
    }

    public static SourceBuilder builder() {
        return new SourceBuilder();
    }

    public String toString() {
        return "Source [path=" + this.path + ", type=" + this.type + ", modules=" + this.modules + ", advertise=" + this.advertise + ", parentPom=" + this.parentPom + ", releaseArtifacts=" + this.releaseArtifacts + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.type, this.modules, this.advertise, this.parentPom, this.releaseArtifacts});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.path, other.path) && this.type == other.type && Objects.equals(this.modules, other.modules) && this.advertise == other.advertise && Objects.equals(this.parentPom, other.parentPom) && Objects.equals(this.releaseArtifacts, other.releaseArtifacts);
    }

    public static class SourceBuilder {
        private Path path;
        private SourceType type;
        private Set<ProjectKeeperModule> modules = Collections.emptySet();
        private boolean advertise = true;
        private ParentPomRef parentPom;
        private List<Path> releaseArtifacts = Collections.emptyList();

        private SourceBuilder() {
        }

        public SourceBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public SourceBuilder type(SourceType type) {
            this.type = type;
            return this;
        }

        public SourceBuilder modules(Set<ProjectKeeperModule> modules) {
            this.modules = modules;
            return this;
        }

        public SourceBuilder advertise(boolean advertise) {
            this.advertise = advertise;
            return this;
        }

        public SourceBuilder parentPom(ParentPomRef parentPom) {
            this.parentPom = parentPom;
            return this;
        }

        public SourceBuilder releaseArtifacts(List<Path> releaseArtifacts) {
            this.releaseArtifacts = releaseArtifacts;
            return this;
        }

        public Source build() {
            return new Source(this);
        }
    }
}

