/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.config.workflow;

import com.exasol.projectkeeper.shared.config.workflow.StepCustomization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class CustomWorkflow {
    private final String workflowName;
    private final String environment;
    private final List<StepCustomization> steps;

    private CustomWorkflow(Builder builder) {
        this.workflowName = Objects.requireNonNull(builder.workflowName, "workflowName");
        this.environment = builder.environment;
        this.steps = builder.steps == null ? Collections.emptyList() : builder.steps;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public List<StepCustomization> getSteps() {
        return this.steps;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "WorkflowOptions [workflowName=" + this.workflowName + ", environment=" + this.environment + ", steps=" + this.steps + "]";
    }

    public int hashCode() {
        return Objects.hash(this.workflowName, this.environment, this.steps);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomWorkflow other = (CustomWorkflow)obj;
        return Objects.equals(this.workflowName, other.workflowName) && Objects.equals(this.environment, other.environment) && Objects.equals(this.steps, other.steps);
    }

    public static class Builder {
        private String workflowName;
        private String environment;
        private List<StepCustomization> steps = null;

        private Builder() {
        }

        public Builder workflowName(String workflowName) {
            this.workflowName = Objects.requireNonNull(workflowName, "workflowName");
            return this;
        }

        public Builder addStep(StepCustomization step) {
            if (this.steps == null) {
                this.steps = new ArrayList<StepCustomization>();
            }
            this.steps.add(Objects.requireNonNull(step, "step"));
            return this;
        }

        public Builder steps(List<StepCustomization> steps) {
            this.steps = Objects.requireNonNull(steps, "steps");
            return this;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public CustomWorkflow build() {
            return new CustomWorkflow(this);
        }
    }
}

