/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.config.workflow;

import com.exasol.projectkeeper.shared.config.workflow.WorkflowStep;
import java.util.Objects;

public final class StepCustomization {
    private final Type type;
    private final String stepId;
    private final WorkflowStep step;

    private StepCustomization(Builder builder) {
        this.type = Objects.requireNonNull(builder.type, "type");
        this.stepId = Objects.requireNonNull(builder.stepId, "stepId");
        this.step = Objects.requireNonNull(builder.step, "step");
    }

    public Type getType() {
        return this.type;
    }

    public String getStepId() {
        return this.stepId;
    }

    public WorkflowStep getStep() {
        return this.step;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "StepCustomization [type=" + this.type + ", stepId=" + this.stepId + ", step=" + this.step + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.stepId, this.step});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StepCustomization other = (StepCustomization)obj;
        return this.type == other.type && Objects.equals(this.stepId, other.stepId) && Objects.equals(this.step, other.step);
    }

    public static class Builder {
        private Type type;
        private String stepId;
        private WorkflowStep step;

        private Builder() {
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public Builder step(WorkflowStep step) {
            this.step = step;
            return this;
        }

        public StepCustomization build() {
            return new StepCustomization(this);
        }
    }

    public static enum Type {
        INSERT_AFTER,
        REPLACE;

    }
}

