/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.dependencies;

import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencies.License;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ProjectDependency
implements BaseDependency {
    private BaseDependency.Type type;
    private String name;
    private String websiteUrl;
    private List<License> licenses = new ArrayList<License>();

    public static Builder builder() {
        return new Builder();
    }

    public ProjectDependency() {
    }

    public ProjectDependency(BaseDependency.Type type, String name, String websiteUrl, List<License> licenses) {
        this.type = type;
        this.name = name;
        this.websiteUrl = websiteUrl;
        this.licenses = licenses;
    }

    @Override
    public BaseDependency.Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public void setType(BaseDependency.Type type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
    }

    public void setLicenses(List<License> licenses) {
        this.licenses = licenses;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.licenses, this.name, this.type, this.websiteUrl});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectDependency other = (ProjectDependency)obj;
        return Objects.equals(this.licenses, other.licenses) && Objects.equals(this.name, other.name) && this.type == other.type && Objects.equals(this.websiteUrl, other.websiteUrl);
    }

    public String toString() {
        return this.type + " dependency '" + this.name + "', " + this.websiteUrl + ", " + this.licenses.size() + " licenses: " + this.licenses.stream().map(License::toString).collect(Collectors.joining(", "));
    }

    public static final class Builder {
        private final ProjectDependency projectDependency = new ProjectDependency();

        public Builder type(BaseDependency.Type type) {
            this.projectDependency.type = type;
            return this;
        }

        public Builder name(String name) {
            this.projectDependency.name = name;
            return this;
        }

        public Builder websiteUrl(String websiteUrl) {
            this.projectDependency.websiteUrl = websiteUrl;
            return this;
        }

        public Builder licenses(List<License> licenses) {
            this.projectDependency.licenses = licenses;
            return this;
        }

        public ProjectDependency build() {
            return this.projectDependency;
        }
    }
}

