/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.dependencychanges;

import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class DependencyChangeReport {
    private Map<BaseDependency.Type, List<DependencyChange>> changes = new EnumMap<BaseDependency.Type, List<DependencyChange>>(BaseDependency.Type.class);

    public static Builder builder() {
        return new Builder();
    }

    public DependencyChangeReport() {
        for (BaseDependency.Type type : BaseDependency.Type.values()) {
            this.changes.put(type, new ArrayList());
        }
    }

    public List<DependencyChange> getChanges(BaseDependency.Type type) {
        return this.changes.get((Object)type);
    }

    public Map<BaseDependency.Type, List<DependencyChange>> getChanges() {
        return this.changes;
    }

    public void setChanges(Map<BaseDependency.Type, List<DependencyChange>> changes) {
        this.changes = changes;
    }

    public String toString() {
        return "DependencyChangeReport [changes=" + this.changes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyChangeReport other = (DependencyChangeReport)obj;
        return Objects.equals(this.changes, other.changes);
    }

    public int hashCode() {
        return Objects.hash(this.changes);
    }

    public static final class Builder {
        private final DependencyChangeReport report = new DependencyChangeReport();

        public Builder typed(BaseDependency.Type type, List<DependencyChange> changes) {
            this.report.changes.put(type, changes);
            return this;
        }

        public Builder mixed(List<DependencyChange> changes, Function<DependencyChange, BaseDependency.Type> typeDetector) {
            for (DependencyChange c : changes) {
                this.report.changes.get((Object)typeDetector.apply(c)).add(c);
            }
            return this;
        }

        public DependencyChangeReport build() {
            return this.report;
        }
    }
}

