/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.dependencychanges;

import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeVisitor;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import java.util.Objects;

public final class NewDependency
implements DependencyChange {
    private final String groupId;
    private final String artifactId;
    private final String version;

    @JsonbCreator
    public NewDependency(@JsonbProperty(value="groupId") String groupId, @JsonbProperty(value="artifactId") String artifactId, @JsonbProperty(value="version") String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void accept(DependencyChangeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "NewDependency [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewDependency other = (NewDependency)obj;
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.version, other.version);
    }
}

