/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.dependencychanges;

import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeVisitor;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import java.util.Objects;

public final class UpdatedDependency
implements DependencyChange {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String newVersion;

    @JsonbCreator
    public UpdatedDependency(@JsonbProperty(value="groupId") String groupId, @JsonbProperty(value="artifactId") String artifactId, @JsonbProperty(value="version") String version, @JsonbProperty(value="newVersion") String newVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.newVersion = newVersion;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Override
    public void accept(DependencyChangeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "UpdatedDependency [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", newVersion=" + this.newVersion + "]";
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.newVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdatedDependency other = (UpdatedDependency)obj;
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.version, other.version) && Objects.equals(this.newVersion, other.newVersion);
    }
}

