/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.mavenprojectcrawler;

import com.exasol.errorreporting.ExaError;

public class ResponseCoder {
    private static final String START_TOKEN = "###SerializedResponseStart###";
    private static final String END_TOKEN = "###SerializedResponseEnd###";

    public void printResponse(String response) {
        if (response.contains(START_TOKEN) || response.contains(END_TOKEN)) {
            throw new IllegalStateException(ExaError.messageBuilder("F-PK-SMC-5").message("Response contained invalid token.", new Object[0]).toString());
        }
        System.out.println(START_TOKEN);
        System.out.println(response);
        System.out.println(END_TOKEN);
    }

    public String decodeResponse(String response) {
        int startIndex = response.indexOf(START_TOKEN);
        int responseStartIndex = startIndex + START_TOKEN.length() + 1;
        int endIndex = response.indexOf(END_TOKEN);
        if (startIndex == -1 || endIndex == -1 || responseStartIndex > endIndex) {
            throw new IllegalStateException(ExaError.messageBuilder("F-PK-SMC-79").message("Invalid response from crawler plugin: {{output}}.", response).ticketMitigation().toString());
        }
        return response.substring(responseStartIndex, endIndex).trim();
    }
}

