/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.shared.repository;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.ExasolVersionMatcher;
import com.exasol.projectkeeper.shared.repository.GitCommit;
import com.exasol.projectkeeper.shared.repository.TaggedCommit;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitRepository
implements AutoCloseable {
    private final Path projectDirectory;
    private final Git git;

    private GitRepository(Git git, Path projectDirectory) {
        this.git = git;
        this.projectDirectory = projectDirectory;
    }

    public static GitRepository open(Path projectDirectory) {
        return new GitRepository(GitRepository.openLocalGitRepository(projectDirectory), projectDirectory);
    }

    private static Git openLocalGitRepository(Path projectDirectory) {
        try {
            return Git.open(projectDirectory.toFile());
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-SMC-32").message("Failed to open local git repository {{repository}}.", new Object[0]).mitigation("If this is a new project you maybe need to create the git project using `git init`.", new Object[0]).parameter("repository", projectDirectory.toString()).toString(), exception);
        }
    }

    public Optional<TaggedCommit> findLatestReleaseCommit(String currentVersion) {
        ExasolVersionMatcher exasolVersionMatcher = new ExasolVersionMatcher();
        return this.getTagsInCurrentBranch().stream().filter(taggedCommit -> exasolVersionMatcher.isExasolStyleVersion(taggedCommit.getTag())).filter(taggedCommit -> !taggedCommit.getTag().equals(currentVersion)).findFirst();
    }

    List<TaggedCommit> getTagsInCurrentBranch() {
        try {
            String currentBranch = this.git.getRepository().getFullBranch();
            this.validateBranchExists(currentBranch);
            return this.getTagsInBranch(currentBranch);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-SMC-33").message("Failed to retrieve latest tag from the local git repository.", new Object[0]).toString(), exception);
        }
    }

    private void validateBranchExists(String currentBranch) {
        if (currentBranch == null) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-SMC-37").message("Could not get checked out branch of repository.", new Object[0]).mitigation("Create a branch and check it out.", new Object[0]).toString());
        }
    }

    private List<TaggedCommit> getTagsInBranch(String branchName) throws IOException {
        Repository repo = this.git.getRepository();
        ObjectId branch = repo.resolve(branchName);
        Map<ObjectId, List<String>> tags = this.getTagsByTheIdOfTheCommitTheyPointTo(repo);
        RevWalk commitWalker = new RevWalk(repo);
        try {
            try {
                commitWalker.markStart(commitWalker.parseCommit(branch));
            }
            catch (NullPointerException exception) {
                List<TaggedCommit> list = Collections.emptyList();
                commitWalker.close();
                return list;
            }
            commitWalker.sort(RevSort.COMMIT_TIME_DESC);
            List<TaggedCommit> list = this.readTagsFromCommits(tags, commitWalker);
            return list;
        }
        finally {
            try {
                commitWalker.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private List<TaggedCommit> readTagsFromCommits(Map<ObjectId, List<String>> tags, RevWalk commitWalker) {
        ArrayList<TaggedCommit> result = new ArrayList<TaggedCommit>();
        for (RevCommit commit : commitWalker) {
            if (!tags.containsKey(commit.getId())) continue;
            List<String> commitsTags = tags.get(commit.getId());
            for (String tag : commitsTags) {
                result.add(new TaggedCommit(commit, tag));
            }
        }
        return result;
    }

    private Map<ObjectId, List<String>> getTagsByTheIdOfTheCommitTheyPointTo(Repository repository) throws IOException {
        HashMap<ObjectId, List<String>> taggedResources = new HashMap<ObjectId, List<String>>();
        for (Ref tagRef : repository.getRefDatabase().getRefsByPrefix("refs/tags/")) {
            String tagName = tagRef.getName().replace("refs/tags/", "");
            ObjectId commitId = this.getTaggedCommitId(repository, tagRef);
            taggedResources.computeIfAbsent(commitId, commit -> new LinkedList()).add(tagName);
        }
        return taggedResources;
    }

    private ObjectId getTaggedCommitId(Repository repository, Ref tagRef) throws IOException {
        try (RevWalk tagSearcher = new RevWalk(repository);){
            RevObject revObject = tagSearcher.parseAny(tagRef.getObjectId());
            if (revObject instanceof RevCommit) {
                ObjectId objectId = revObject.getId();
                return objectId;
            }
            if (revObject instanceof RevTag) {
                ObjectId objectId = ((RevTag)revObject).getObject().getId();
                return objectId;
            }
            throw new UnsupportedOperationException(ExaError.messageBuilder("F-PK-SMC-44").message("Unsupported tag target {{target class name}}.", new Object[0]).parameter("target class name", revObject.getClass().getName()).ticketMitigation().toString());
        }
    }

    public void extractFileFromCommit(Path relativeFilePath, GitCommit commit, Path targetFile) throws FileNotFoundException {
        try {
            this.extractFileFromCommit(relativeFilePath, this.git, commit.getCommit(), targetFile);
        }
        catch (FileNotFoundException exception) {
            throw exception;
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-SMC-43").message("Failed to copy file {{path}} from git repo {{git repo}} at commit {{commit}} to {{target file}}.", relativeFilePath, this.projectDirectory, commit.getCommit(), targetFile).toString(), exception);
        }
    }

    public String getFileFromCommit(Path relativeFilePath, GitCommit commit) throws FileNotFoundException {
        Repository repository = this.git.getRepository();
        ObjectId objectForVersionOfFile = this.findFile(commit.getCommit(), repository, relativeFilePath);
        ObjectReader reader = repository.newObjectReader();
        try {
            ObjectLoader objectLoader = reader.open(objectForVersionOfFile);
            String string = new String(objectLoader.getBytes(), StandardCharsets.UTF_8);
            if (reader != null) {
                reader.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (FileNotFoundException exception) {
                throw exception;
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-SMC-80").message("Failed to retrieve file {{path}} from git repo {{git repo}} at commit {{commit}}.", relativeFilePath, this.projectDirectory, commit.getCommit()).toString(), exception);
            }
        }
    }

    private void extractFileFromCommit(Path relativeFilePath, Git git, RevCommit commit, Path targetFile) throws IOException {
        Repository repository = git.getRepository();
        ObjectId objectForVersionOfFile = this.findFile(commit, repository, relativeFilePath);
        this.copyVersionOfFile(repository, objectForVersionOfFile, targetFile);
    }

    private void copyVersionOfFile(Repository repository, ObjectId objectForVersionOfFile, Path targetFile) throws IOException {
        Path targetDir = targetFile.getParent();
        if (!Files.exists(targetDir, new LinkOption[0])) {
            Files.createDirectories(targetDir, new FileAttribute[0]);
        }
        try (ObjectReader reader = repository.newObjectReader();
             FileOutputStream outputStream = new FileOutputStream(targetFile.toFile());
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            ObjectLoader objectLoader = reader.open(objectForVersionOfFile);
            objectLoader.copyTo(bufferedOutputStream);
        }
    }

    private ObjectId findFile(RevCommit commit, Repository repository, Path expectedPath) throws IOException {
        Path normalizedExpected = expectedPath.normalize();
        try (TreeWalk treeWalk = new TreeWalk(repository);){
            treeWalk.addTree(commit.getTree());
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                Path currentPath = Path.of(treeWalk.getPathString(), new String[0]).normalize();
                if (treeWalk.isSubtree()) {
                    if (normalizedExpected.startsWith(currentPath)) {
                        treeWalk.enterSubtree();
                    }
                    continue;
                }
                if (!normalizedExpected.equals(currentPath)) continue;
                ObjectId objectId = treeWalk.getObjectId(0);
                return objectId;
            }
        }
        throw new FileNotFoundException(ExaError.messageBuilder("E-PK-SMC-35").message("Failed to read file {{file path}} from commit {{commit id}}.", new Object[0]).parameter("file path", expectedPath).parameter("commit id", commit.getName()).mitigation("Make sure that the file exists at the given commit.", new Object[0]).toString());
    }

    public Optional<String> getRepoNameFromRemote() {
        try {
            Object remotes = this.git.remoteList().call();
            Optional<RemoteConfig> origin = remotes.stream().filter(remote -> remote.getName().equals("origin")).findAny();
            if (origin.isPresent()) {
                String path = origin.get().getURIs().get(0).getPath();
                String[] pathParts = path.split("/");
                String repoName = pathParts[pathParts.length - 1].replace(".git", "");
                return Optional.of(repoName);
            }
            return Optional.empty();
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @Override
    public void close() {
        this.git.close();
    }
}

