/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources;

import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependencies;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeReport;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.sources.analyze.generic.RepoNameReader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;

public final class AnalyzedSourceImpl
implements AnalyzedSource {
    private final Path path;
    private final Set<ProjectKeeperModule> modules;
    private final boolean advertise;
    private final String moduleName;
    private final String projectName;
    private final String version;
    private final DependencyChangeReport dependencyChanges;
    private final ProjectDependencies dependencies;
    private final boolean isRootProject;

    public static String projectName(Path projectDir, Source source) {
        if (source.isRoot()) {
            return RepoNameReader.getRepoName(projectDir);
        }
        return RepoNameReader.getRepoName(source.getPath().getParent());
    }

    private AnalyzedSourceImpl(AnalyzedSourceImplBuilder builder) {
        this.path = builder.path;
        this.modules = builder.modules;
        this.advertise = builder.advertise;
        this.moduleName = builder.moduleName;
        this.projectName = builder.projectName;
        this.version = builder.version;
        this.dependencyChanges = builder.dependencyChanges;
        this.dependencies = builder.dependencies;
        this.isRootProject = builder.isRootProject;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Set<ProjectKeeperModule> getModules() {
        return this.modules;
    }

    @Override
    public boolean isAdvertised() {
        return this.advertise;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public DependencyChangeReport getDependencyChanges() {
        return this.dependencyChanges;
    }

    @Override
    public ProjectDependencies getDependencies() {
        return this.dependencies;
    }

    public boolean isRootProject() {
        return this.isRootProject;
    }

    public static AnalyzedSourceImplBuilder builder() {
        return new AnalyzedSourceImplBuilder();
    }

    public String toString() {
        return "AnalyzedSourceImpl [path=" + this.path + ", modules=" + this.modules + ", advertise=" + this.advertise + ", moduleName=" + this.moduleName + ", projectName=" + this.projectName + ", version=" + this.version + ", dependencyChanges=" + this.dependencyChanges + ", dependencies=" + this.dependencies + ", isRootProject=" + this.isRootProject + "]";
    }

    public int hashCode() {
        return Objects.hash(this.path, this.modules, this.advertise, this.moduleName, this.projectName, this.version, this.dependencyChanges, this.dependencies, this.isRootProject);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedSourceImpl other = (AnalyzedSourceImpl)obj;
        return Objects.equals(this.path, other.path) && Objects.equals(this.modules, other.modules) && this.advertise == other.advertise && Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.projectName, other.projectName) && Objects.equals(this.version, other.version) && Objects.equals(this.dependencyChanges, other.dependencyChanges) && Objects.equals(this.dependencies, other.dependencies) && this.isRootProject == other.isRootProject;
    }

    public static class AnalyzedSourceImplBuilder {
        private Path path;
        private Set<ProjectKeeperModule> modules;
        private boolean advertise;
        private String moduleName;
        private String projectName;
        private String version;
        private DependencyChangeReport dependencyChanges;
        private ProjectDependencies dependencies;
        private boolean isRootProject;

        private AnalyzedSourceImplBuilder() {
        }

        public AnalyzedSourceImplBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public AnalyzedSourceImplBuilder modules(Set<ProjectKeeperModule> modules) {
            this.modules = modules;
            return this;
        }

        public AnalyzedSourceImplBuilder advertise(boolean advertise) {
            this.advertise = advertise;
            return this;
        }

        public AnalyzedSourceImplBuilder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public AnalyzedSourceImplBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public AnalyzedSourceImplBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AnalyzedSourceImplBuilder dependencyChanges(DependencyChangeReport dependencyChanges) {
            this.dependencyChanges = dependencyChanges;
            return this;
        }

        public AnalyzedSourceImplBuilder dependencies(ProjectDependencies dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public AnalyzedSourceImplBuilder isRootProject(boolean isRootProject) {
            this.isRootProject = isRootProject;
            return this;
        }

        public AnalyzedSourceImpl build() {
            return new AnalyzedSourceImpl(this);
        }
    }
}

