/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.JavaProjectCrawlerRunner;
import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.config.SourceType;
import com.exasol.projectkeeper.shared.mavenprojectcrawler.CrawledMavenProject;
import com.exasol.projectkeeper.sources.AnalyzedMavenSource;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.sources.analyze.LanguageSpecificSourceAnalyzer;
import com.exasol.projectkeeper.validators.pom.PomFileIO;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;

public class MavenSourceAnalyzer
implements LanguageSpecificSourceAnalyzer {
    private final Path mvnRepositoryOverride;
    private final String ownVersion;

    public MavenSourceAnalyzer(Path mvnRepositoryOverride, String ownVersion) {
        this.mvnRepositoryOverride = mvnRepositoryOverride;
        this.ownVersion = ownVersion;
    }

    @Override
    public List<AnalyzedSource> analyze(Path projectDir, List<Source> sources) {
        Map<String, CrawledMavenProject> crawledMvnSources = this.runCrawlerForMvnSources(sources);
        return sources.stream().map(source -> this.analyzeSource(projectDir, (Source)source, crawledMvnSources)).collect(Collectors.toList());
    }

    private Map<String, CrawledMavenProject> runCrawlerForMvnSources(List<Source> sources) {
        List mvnSourcePaths = sources.stream().filter(source -> SourceType.MAVEN.equals((Object)source.getType())).map(Source::getPath).collect(Collectors.toList());
        if (mvnSourcePaths.isEmpty()) {
            return Collections.emptyMap();
        }
        return new JavaProjectCrawlerRunner(this.mvnRepositoryOverride, this.ownVersion).crawlProject((Path[])mvnSourcePaths.toArray(Path[]::new)).getCrawledProjects();
    }

    private AnalyzedSource analyzeSource(Path projectDir, Source source, Map<String, CrawledMavenProject> crawledMvnSources) {
        if (SourceType.MAVEN.equals((Object)source.getType())) {
            Model model = this.readMavenModel(source);
            String artifactId = model.getArtifactId();
            String rawProjectName = model.getName();
            String projectName = rawProjectName == null || rawProjectName.isBlank() ? artifactId : rawProjectName;
            CrawledMavenProject crawledMavenProject = this.getCrawlResultForProject(source, crawledMvnSources);
            boolean isRoot = projectDir.relativize(source.getPath()).equals(Path.of("pom.xml", new String[0]));
            return AnalyzedMavenSource.builder().path(source.getPath()).modules(source.getModules()).advertise(source.isAdvertised()).artifactId(artifactId).projectName(projectName).dependencies(crawledMavenProject.getProjectDependencies()).dependencyChanges(crawledMavenProject.getDependencyChangeReport()).version(crawledMavenProject.getProjectVersion()).isRootProject(isRoot).javaVersion(crawledMavenProject.getJavaVersion()).releaseArtifactName(crawledMavenProject.getReleaseArtifactName()).build();
        }
        throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-93").message("Analyzing of {{type}} is not supported by MavenSourceAnalyzer", new Object[]{source.getType()}).ticketMitigation().toString());
    }

    private CrawledMavenProject getCrawlResultForProject(Source source, Map<String, CrawledMavenProject> crawlResult) {
        String key = source.getPath().toString().replace(FileSystems.getDefault().getSeparator(), "/");
        if (!crawlResult.containsKey(key)) {
            throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-117").message("The crawl result did not contain the project {{project}}.", source.getPath()).ticketMitigation().toString());
        }
        return crawlResult.get(key);
    }

    private Model readMavenModel(Source source) {
        return new PomFileIO().readPom(source.getPath());
    }
}

