/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.generic;

import com.exasol.projectkeeper.OsCheck;
import com.exasol.projectkeeper.sources.analyze.generic.ShellCommand;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MavenProcessBuilder {
    private final List<String> args = new ArrayList<String>();
    private Path workingDir = null;
    private Duration timeout = null;

    private MavenProcessBuilder() {
    }

    public static MavenProcessBuilder create() {
        MavenProcessBuilder builder = new MavenProcessBuilder();
        builder.addArgument("--batch-mode");
        return builder;
    }

    public MavenProcessBuilder addArguments(String ... arguments) {
        this.args.addAll(Arrays.asList(arguments));
        return this;
    }

    public MavenProcessBuilder addArgument(String argument) {
        this.args.add(argument);
        return this;
    }

    public MavenProcessBuilder workingDir(Path workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public MavenProcessBuilder timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public ShellCommand buildCommand() {
        return ShellCommand.builder().command(MavenProcessBuilder.getMavenExecutable()).args(this.args).timeout(this.timeout).workingDir(this.workingDir).build();
    }

    private static String getMavenExecutable() {
        return "mvn" + OsCheck.suffix(".cmd");
    }
}

