/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.generic;

import com.exasol.projectkeeper.shared.repository.GitRepository;
import com.exasol.projectkeeper.shared.repository.TaggedCommit;
import com.exasol.projectkeeper.sources.analyze.generic.GitService;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Optional;

public class PreviousRelease {
    private final GitService git;
    private Path projectDir;
    private String version;
    private Path file;

    public PreviousRelease(GitService git) {
        this.git = git;
    }

    public PreviousRelease projectDir(Path projectDir) {
        this.projectDir = projectDir;
        return this;
    }

    public PreviousRelease currentVersion(String version) {
        this.version = version;
        return this;
    }

    public PreviousRelease file(Path relative) {
        this.file = relative;
        return this;
    }

    public Optional<String> getContent() {
        try (GitRepository repo = this.git.getRepository(this.projectDir);){
            Optional<String> optional = repo.findLatestReleaseCommit(this.version).flatMap(tag -> this.getContent(repo, (TaggedCommit)tag));
            return optional;
        }
    }

    private Optional<String> getContent(GitRepository repo, TaggedCommit tag) {
        try {
            return Optional.of(repo.getFileFromCommit(this.file, tag.getCommit()));
        }
        catch (FileNotFoundException exception) {
            return Optional.empty();
        }
    }
}

