/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.generic;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.sources.analyze.generic.ProcessResult;
import com.exasol.projectkeeper.stream.AsyncStreamReader;
import com.exasol.projectkeeper.stream.CollectingConsumer;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class SimpleProcess {
    private static final Logger LOGGER = Logger.getLogger(SimpleProcess.class.getName());
    private final Process process;
    private final CollectingConsumer outputStreamConsumer;
    private final CollectingConsumer errorStreamConsumer;
    private final Path workingDirectory;
    private final List<String> command;
    private final Instant startTime;

    SimpleProcess(Process process, CollectingConsumer outputStreamConsumer, CollectingConsumer errorStreamConsumer, Path workingDirectory, List<String> command, Instant startTime) {
        this.process = process;
        this.outputStreamConsumer = outputStreamConsumer;
        this.errorStreamConsumer = errorStreamConsumer;
        this.workingDirectory = workingDirectory;
        this.command = command;
        this.startTime = startTime;
    }

    public static SimpleProcess start(List<String> command) {
        return SimpleProcess.start(null, command);
    }

    public static SimpleProcess start(Path workingDirectory, List<String> command) throws IllegalStateException {
        LOGGER.finest(() -> "Executing command '" + SimpleProcess.formatCommand(command) + "' in working dir '" + workingDirectory + "'...");
        try {
            Process process = new ProcessBuilder(command).directory(workingDirectory == null ? null : workingDirectory.toFile()).redirectErrorStream(false).start();
            Instant startTime = Instant.now();
            CollectingConsumer outputStreamConsumer = new AsyncStreamReader().startCollectingConsumer(process.getInputStream());
            CollectingConsumer errorStreamConsumer = new AsyncStreamReader().startCollectingConsumer(process.getErrorStream());
            return new SimpleProcess(process, outputStreamConsumer, errorStreamConsumer, workingDirectory, command, startTime);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-125").message("Error executing command {{command}}.", String.join((CharSequence)" ", command)).mitigation("Verify that the {{executable name}} executable is on the PATH.", command.get(0)).toString(), exception);
        }
    }

    public void waitUntilFinished(Duration executionTimeout) {
        this.waitForExecutionFinished(executionTimeout);
        Duration duration = Duration.between(this.startTime, Instant.now());
        int exitCode = this.process.exitValue();
        if (exitCode != 0) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-126").message("Failed to run command {{executed command}} in {{working directory}}, exit code was {{exit code}} after {{duration}}. Output:\n{{std out}}\nError output:\n{{std error}}", this.formatCommand(), this.workingDirectory, exitCode, duration, this.getOutputStreamContent().trim(), this.getErrorStreamContent().trim()).toString());
        }
        LOGGER.finest(() -> "Command '" + this.formatCommand() + "' finished successfully after " + duration);
    }

    public String getOutputStreamContent() {
        try {
            return this.outputStreamConsumer.getContent(Duration.ofSeconds(5L));
        }
        catch (InterruptedException exception) {
            throw this.handleInterruptedException(exception);
        }
    }

    public String getErrorStreamContent() {
        try {
            return this.errorStreamConsumer.getContent(Duration.ofSeconds(5L));
        }
        catch (InterruptedException exception) {
            throw this.handleInterruptedException(exception);
        }
    }

    public ProcessResult getResult() {
        return new ProcessResult(this.getOutputStreamContent(), this.getErrorStreamContent());
    }

    private void waitForExecutionFinished(Duration executionTimeout) {
        try {
            if (!this.process.waitFor(executionTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                String outputStreamContentUntilNow = this.outputStreamConsumer.getCurrentContent().trim();
                String errorStreamContentUntilNow = this.errorStreamConsumer.getCurrentContent().trim();
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-128").message("Timeout while waiting {{timeout|u}}ms for command {{executed command}}. Output was {{std output}}\nError output: {{std error}}", executionTimeout.toMillis(), this.formatCommand(), outputStreamContentUntilNow, errorStreamContentUntilNow).toString());
            }
        }
        catch (InterruptedException exception) {
            throw this.handleInterruptedException(exception);
        }
    }

    private RuntimeException handleInterruptedException(InterruptedException exception) {
        Thread.currentThread().interrupt();
        return new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-129").message("Interrupted while waiting for command {{executed command|u}}", this.formatCommand()).toString(), exception);
    }

    private static String formatCommand(List<String> command) {
        return String.join((CharSequence)" ", command);
    }

    private String formatCommand() {
        return SimpleProcess.formatCommand(this.command);
    }
}

