/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.golang;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.OsCheck;
import com.exasol.projectkeeper.sources.analyze.generic.CommandExecutor;
import com.exasol.projectkeeper.sources.analyze.generic.ShellCommand;
import com.exasol.projectkeeper.sources.analyze.generic.SimpleProcess;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.logging.Logger;

public class GoBinary {
    public static final GoBinary GO = new GoBinary(null, "go"){

        @Override
        boolean isInstalled() {
            return true;
        }
    };
    public static final GoBinary GO_LICENSES = new GoBinary("github.com/google/go-licenses@v1.6.0", "go-licenses", Duration.ofMinutes(6L));
    private static final Logger LOGGER = Logger.getLogger(GoBinary.class.getName());
    private final CommandExecutor executor;
    private final String moduleName;
    private final String binaryName;
    private final Duration timeout;
    private Path goPath;

    GoBinary(String moduleName, String name) {
        this(moduleName, name, Duration.ofMinutes(2L));
    }

    GoBinary(String moduleName, String name, Duration timeout) {
        this(new CommandExecutor(), moduleName, name, timeout);
    }

    GoBinary(CommandExecutor executor, String moduleName, String binaryName, Duration timeout) {
        this.moduleName = moduleName;
        this.binaryName = binaryName;
        this.executor = executor;
        this.timeout = timeout;
    }

    public GoBinary install() {
        if (this.isInstalled()) {
            return this;
        }
        LOGGER.info(() -> "Installing missing go binary " + this.nameWithSuffix());
        ShellCommand shellCommand = ShellCommand.builder().timeout(this.timeout).command(GO.command()).args("install", this.moduleName).build();
        try {
            this.executor.execute(shellCommand);
        }
        catch (IllegalStateException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-161").message("Error installing go binary {{binary}}.", this.binaryName).toString(), exception);
        }
        return this;
    }

    boolean isInstalled() {
        return Files.exists(this.path(), new LinkOption[0]);
    }

    public String command() {
        Path path = this.path();
        if (Files.exists(path, new LinkOption[0])) {
            return path.toString();
        }
        return this.binaryName;
    }

    Path path() {
        return this.getGoBinPath().resolve("bin").resolve(this.nameWithSuffix());
    }

    String nameWithSuffix() {
        return this.binaryName + OsCheck.suffix(".exe");
    }

    private Path getGoBinPath() {
        if (this.goPath == null) {
            this.goPath = GoBinary.readGoPath();
        }
        return this.goPath;
    }

    private static Path readGoPath() {
        SimpleProcess process = SimpleProcess.start(List.of("go", "env", "GOPATH"));
        process.waitUntilFinished(Duration.ofSeconds(5L));
        Path goPath = Path.of(process.getOutputStreamContent().trim(), new String[0]);
        LOGGER.fine(() -> "Found GOPATH '" + goPath + "'");
        return goPath;
    }
}

