/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.golang;

import com.exasol.projectkeeper.shared.dependencies.VersionedDependency;
import com.exasol.projectkeeper.sources.analyze.golang.GoModFileParser;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class GoModFile {
    private final String moduleName;
    private final String goVersion;
    private final List<VersionedDependency> dependencies;

    GoModFile(String moduleName, String goVersion, List<VersionedDependency> dependencies) {
        this.moduleName = moduleName;
        this.goVersion = goVersion;
        this.dependencies = dependencies;
    }

    private GoModFile(GoModFileParser parser) {
        this(parser.moduleName, parser.goVersion, parser.dependencies);
    }

    static GoModFile parse(String content) {
        GoModFileParser parser = new GoModFileParser();
        parser.parse(content);
        return new GoModFile(parser);
    }

    List<VersionedDependency> getDirectDependencies() {
        return this.dependencies.stream().filter(Predicate.not(VersionedDependency::isIndirect)).collect(Collectors.toList());
    }

    String getModuleName() {
        return this.moduleName;
    }

    String getGoVersion() {
        return this.goVersion;
    }

    List<VersionedDependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return "GoModFile [moduleName=" + this.moduleName + ", goVersion=" + this.goVersion + ", dependencies=" + this.dependencies + "]";
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.goVersion, this.dependencies);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoModFile other = (GoModFile)obj;
        return Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.goVersion, other.goVersion) && Objects.equals(this.dependencies, other.dependencies);
    }
}

