/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.golang;

import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependencies;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeReport;
import com.exasol.projectkeeper.sources.analyze.golang.GolangDependencyType;
import com.exasol.projectkeeper.sources.analyze.golang.GolangServices;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;

class GolangDependencyChangeCalculator {
    static final Logger LOGGER = Logger.getLogger(GolangDependencyChangeCalculator.class.getName());
    private final GolangServices golangServices;
    private final Path projectDir;
    private final Source source;
    private final ProjectDependencies dependencies;

    static DependencyChangeReport calculateDepencencyChanges(GolangServices golangServices, Path projectDir, Source source, ProjectDependencies dependencies) {
        return new GolangDependencyChangeCalculator(golangServices, projectDir, source, dependencies).calculate();
    }

    GolangDependencyChangeCalculator(GolangServices golangServices, Path projectDir, Source source, ProjectDependencies dependencies) {
        this.golangServices = golangServices;
        this.projectDir = projectDir;
        this.source = source;
        this.dependencies = dependencies;
    }

    private DependencyChangeReport calculate() {
        List<DependencyChange> changes = this.golangServices.getDependencyChanges(this.projectDir, this.getRelativeModPath());
        GolangDependencyType typeDetector = new GolangDependencyType(this.dependencies.getDependencies());
        return DependencyChangeReport.builder().mixed(changes, typeDetector::getType).build();
    }

    private Path getRelativeModPath() {
        if (this.source.getPath().isAbsolute()) {
            return this.projectDir.relativize(this.source.getPath());
        }
        return this.source.getPath();
    }
}

