/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.golang;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.config.ProjectKeeperConfig;
import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.config.SourceType;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependencies;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.sources.AnalyzedSourceImpl;
import com.exasol.projectkeeper.sources.analyze.LanguageSpecificSourceAnalyzer;
import com.exasol.projectkeeper.sources.analyze.golang.GoModule;
import com.exasol.projectkeeper.sources.analyze.golang.GolangDependencyCalculator;
import com.exasol.projectkeeper.sources.analyze.golang.GolangDependencyChangeCalculator;
import com.exasol.projectkeeper.sources.analyze.golang.GolangServices;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class GolangSourceAnalyzer
implements LanguageSpecificSourceAnalyzer {
    private final GolangServices golangServices;

    public GolangSourceAnalyzer(ProjectKeeperConfig config) {
        this(new GolangServices(config));
    }

    GolangSourceAnalyzer(GolangServices golangServices) {
        this.golangServices = golangServices;
    }

    @Override
    public List<AnalyzedSource> analyze(Path projectDir, List<Source> sources) {
        return sources.stream().map(source -> this.analyzeSource(projectDir, (Source)source)).collect(Collectors.toList());
    }

    private AnalyzedSource analyzeSource(Path projectDir, Source source) {
        this.validateGolangSource(source);
        Path absoluteSourceDir = this.getAbsoluteSourceDir(projectDir, source);
        GoModule moduleInfo = this.golangServices.getModuleInfo(absoluteSourceDir);
        ProjectDependencies dependencies = GolangDependencyCalculator.calculateDependencies(this.golangServices, absoluteSourceDir, moduleInfo);
        return AnalyzedSourceImpl.builder().version(this.golangServices.getProjectVersion()).isRootProject(source.isRoot()).advertise(source.isAdvertised()).modules(source.getModules()).path(source.getPath()).projectName(AnalyzedSourceImpl.projectName(projectDir, source)).moduleName(moduleInfo.getName()).dependencies(dependencies).dependencyChanges(GolangDependencyChangeCalculator.calculateDepencencyChanges(this.golangServices, projectDir, source, dependencies)).build();
    }

    private Path getAbsoluteSourceDir(Path projectDir, Source source) {
        if (source.isRoot()) {
            return projectDir;
        }
        return projectDir.resolve(source.getPath().getParent());
    }

    private void validateGolangSource(Source source) {
        if (source.getType() != SourceType.GOLANG) {
            throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-130").message("Analyzing of {{type}} is not supported by GolangSourceAnalyzer", new Object[]{source.getType()}).ticketMitigation().toString());
        }
        if (!source.getPath().getFileName().equals(Path.of("go.mod", new String[0]))) {
            throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-133").message("Invalid path {{path}} for go source.", source.getPath()).mitigation("The path must point to a \"go.mod\" file.", new Object[0]).toString());
        }
    }
}

