/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.npm;

import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeReport;
import com.exasol.projectkeeper.sources.analyze.generic.DependencyChanges;
import com.exasol.projectkeeper.sources.analyze.npm.PackageJson;
import java.util.List;
import java.util.Optional;

public class NpmDependencyChanges {
    private final PackageJson current;
    private final Optional<PackageJson> previous;

    public static DependencyChangeReport report(PackageJson current, Optional<PackageJson> previous) {
        return new NpmDependencyChanges(current, previous).getReport();
    }

    NpmDependencyChanges(PackageJson packageJson, Optional<PackageJson> previous) {
        this.current = packageJson;
        this.previous = previous;
    }

    DependencyChangeReport getReport() {
        DependencyChangeReport.Builder builder = DependencyChangeReport.builder();
        for (BaseDependency.Type type : BaseDependency.Type.values()) {
            builder.typed(type, this.getChanges(type));
        }
        return builder.build();
    }

    private List<DependencyChange> getChanges(BaseDependency.Type type) {
        return DependencyChanges.builder().from(this.previous.map(p -> p.getDependencies(type))).to(this.current.getDependencies(type)).build();
    }
}

