/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.npm;

import com.exasol.projectkeeper.shared.dependencies.License;
import jakarta.json.JsonObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NpmLicense {
    private static final Pattern PATTERN = Pattern.compile("^(.+)@([0-9]+(\\.[0-9]+)*+)$");
    private final String module;
    private final String version;
    private final String name;
    private final String url;

    static NpmLicense from(String moduleAndVersion, JsonObject licenseInfos) {
        JsonObject o = licenseInfos.getJsonObject(moduleAndVersion);
        String name = NpmLicense.jString(o, "licenses");
        String mainUrl = NpmLicense.jString(o, "repository");
        String[] p = NpmLicense.split(moduleAndVersion);
        return new NpmLicense(p[0], p[1], name, mainUrl);
    }

    private static String jString(JsonObject o, String key) {
        return o.containsKey(key) ? o.getString(key) : null;
    }

    private static String[] split(String moduleAndVersion) {
        String[] stringArray;
        Matcher matcher = PATTERN.matcher(moduleAndVersion);
        if (matcher.matches()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = matcher.group(1);
            stringArray = stringArray2;
            stringArray2[1] = matcher.group(2);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = moduleAndVersion;
            stringArray = stringArray3;
            stringArray3[1] = null;
        }
        return stringArray;
    }

    private NpmLicense(String module, String version, String name, String url) {
        this.module = module;
        this.version = version;
        this.name = name;
        this.url = url;
    }

    String getModule() {
        return this.module;
    }

    String getVersion() {
        return this.version;
    }

    License toLicense() {
        return new License(this.name, this.url);
    }
}

