/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.npm;

import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.sources.AnalyzedSourceImpl;
import com.exasol.projectkeeper.sources.analyze.LanguageSpecificSourceAnalyzer;
import com.exasol.projectkeeper.sources.analyze.generic.CommandExecutor;
import com.exasol.projectkeeper.sources.analyze.generic.GitService;
import com.exasol.projectkeeper.sources.analyze.npm.NpmDependencyChanges;
import com.exasol.projectkeeper.sources.analyze.npm.NpmServices;
import com.exasol.projectkeeper.sources.analyze.npm.PackageJson;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NpmSourceAnalyzer
implements LanguageSpecificSourceAnalyzer {
    private final NpmServices npmServices;

    public NpmSourceAnalyzer() {
        this(new NpmServices(new CommandExecutor(), new GitService()));
    }

    NpmSourceAnalyzer(NpmServices npmServices) {
        this.npmServices = npmServices;
    }

    @Override
    public List<AnalyzedSource> analyze(Path projectDir, List<Source> sources) {
        return sources.stream().map(source -> this.analyzeSource(projectDir, (Source)source)).collect(Collectors.toList());
    }

    private AnalyzedSource analyzeSource(Path projectDir, Source source) {
        Path path = source.getPath();
        PackageJson current = this.npmServices.readPackageJson(projectDir.resolve(path));
        Optional<PackageJson> previous = this.npmServices.retrievePrevious(projectDir, current);
        return AnalyzedSourceImpl.builder().version(current.getVersion()).isRootProject(source.isRoot()).advertise(source.isAdvertised()).modules(source.getModules()).path(path).projectName(AnalyzedSourceImpl.projectName(projectDir, source)).moduleName(current.getModuleName()).dependencies(this.npmServices.getDependencies(current)).dependencyChanges(NpmDependencyChanges.report(current, previous)).build();
    }
}

