/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.npm;

import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencies.VersionedDependency;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

class PackageJson {
    private final Path path;
    private final String moduleName;
    private final String version;
    private final List<VersionedDependency> dependencies;

    PackageJson(Path path, String moduleName, String version, List<VersionedDependency> dependencies) {
        this.path = path;
        this.moduleName = moduleName;
        this.version = version;
        this.dependencies = dependencies;
    }

    Path getPath() {
        return this.path;
    }

    Path getWorkingDir() {
        return this.path.getParent();
    }

    String getModuleName() {
        return this.moduleName;
    }

    String getVersion() {
        return this.version;
    }

    List<VersionedDependency> getDependencies() {
        return this.dependencies;
    }

    List<VersionedDependency> getDependencies(BaseDependency.Type type) {
        return this.dependencies.stream().filter(d -> d.getType() == type).collect(Collectors.toList());
    }
}

