/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.stream;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.stream.StreamConsumer;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CollectingConsumer
implements StreamConsumer {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final StringBuilder stringBuilder = new StringBuilder();

    @Override
    public void accept(String line) {
        this.stringBuilder.append(line).append("\n");
    }

    @Override
    public void readFinished() {
        this.countDownLatch.countDown();
    }

    @Override
    public void readFailed(IOException exception) {
        this.countDownLatch.countDown();
    }

    public String getContent(Duration timeout) throws InterruptedException {
        boolean result = this.countDownLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
        if (!result) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-99").message("Stream reading did not finish after timeout of {{timeout}}. Content collected until now: {{content}}.", timeout, this.stringBuilder.toString()).ticketMitigation().toString());
        }
        return this.getCurrentContent();
    }

    public String getCurrentContent() {
        return this.stringBuilder.toString();
    }
}

