/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;

public abstract class AbstractFileValidator
implements Validator {
    private final Path absoluteFilePath;
    protected final Path relativeFilePath;

    protected AbstractFileValidator(Path projectDirectory, Path filePath) {
        this.relativeFilePath = filePath;
        this.absoluteFilePath = projectDirectory.resolve(filePath);
    }

    @Override
    public final List<ValidationFinding> validate() {
        if (this.isValidationEnabled()) {
            return this.runValidation();
        }
        return Collections.emptyList();
    }

    private List<ValidationFinding> runValidation() {
        if (!Files.exists(this.absoluteFilePath, new LinkOption[0])) {
            return List.of(this.getMissingFileFinding());
        }
        return this.validateContent(this.absoluteFilePath);
    }

    private ValidationFinding getMissingFileFinding() {
        return SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-56").message("Could not find required file {{file name}}.", new Object[0]).parameter("file name", this.relativeFilePath.toString(), "Name of the required file.").toString()).andFix(this.getCreateFileFix()).build();
    }

    protected SimpleValidationFinding.Fix getCreateFileFix() {
        return log -> {
            try {
                Files.createDirectories(this.absoluteFilePath.getParent(), new FileAttribute[0]);
                this.writeTemplateFile(this.absoluteFilePath);
                log.info("Created '" + this.relativeFilePath + "'. Don't forget to update its content!");
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-63").message("Failed to create required file {{file path}}.", this.relativeFilePath).toString());
            }
        };
    }

    protected abstract void writeTemplateFile(Path var1) throws IOException;

    protected abstract List<ValidationFinding> validateContent(Path var1);

    protected boolean isValidationEnabled() {
        return true;
    }

    protected Path getAbsoluteFilePath() {
        return this.absoluteFilePath;
    }
}

