/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DeletedFilesValidator
implements Validator {
    private static final String RELEASE_DROID_WORKFLOW_WARNING = "Release-droid workflows are replaced by release.yml";
    private static final String GITHUB_WORKFLOWS = ".github/workflows";
    private static final Map<Path, String> FILES_THAT_MUST_NOT_EXIST = Map.of(Path.of(".github/workflows", "release_droid_print_quick_checksum.yml"), "Release-droid workflows are replaced by release.yml", Path.of(".github/workflows", "release_droid_release_on_maven_central.yml"), "Release-droid workflows are replaced by release.yml", Path.of(".github/workflows", "release_droid_upload_github_release_assets.yml"), "Release-droid workflows are replaced by release.yml", Path.of(".github/workflows", "release_droid_prepare_original_checksum.yml"), "Release-droid workflows are replaced by release.yml", Path.of("release_config.yml", new String[0]), "Release-droid configuration is replaced by release.yml");
    private final Path projectDirectory;

    public DeletedFilesValidator(Path projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    @Override
    public List<ValidationFinding> validate() {
        return FILES_THAT_MUST_NOT_EXIST.entrySet().stream().map(entry -> {
            Path fileThatMustNotExist = (Path)entry.getKey();
            String reason = (String)entry.getValue();
            Path pathThatMustExist = this.projectDirectory.resolve(fileThatMustNotExist);
            File file = pathThatMustExist.toFile();
            if (file.exists()) {
                return SimpleValidationFinding.withMessage(this.getFileExistsErrorMessage(fileThatMustNotExist, reason)).andFix(this.getFix(fileThatMustNotExist.toString(), file)).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getFileExistsErrorMessage(Path fileThatMustNotExist, String reason) {
        return ExaError.messageBuilder("E-PK-CORE-26").message("{{FILE}} exists but must not exist. Reason: {{REASON|u}}", fileThatMustNotExist.toString(), reason).toString();
    }

    private SimpleValidationFinding.Fix getFix(String fileName, File file) {
        return log -> {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-27").message("Failed to delete {{FILE}}.", new Object[0]).parameter("FILE", fileName).mitigation("Check file permissions.", new Object[0]).toString(), exception);
            }
        };
    }
}

