/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.sources.AnalyzedMavenSource;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.AbstractFileContentValidator;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ReadmeFileValidator
extends AbstractFileContentValidator {
    private static final String NL = System.lineSeparator();
    private static final String NATIVE_IMAGE_DEV_GUIDE = "https://github.com/exasol/project-keeper/blob/main/doc/user_guide/preparing_a_project_for_native_image_builds.md";
    private final String projectName;
    private final String repoName;
    private final List<AnalyzedSource> sources;
    private final boolean hasNativeImageSource;

    public ReadmeFileValidator(Path projectDirectory, String projectName, String repoName, List<AnalyzedSource> sources) {
        super(projectDirectory, Path.of("README.md", new String[0]));
        this.projectName = projectName;
        this.repoName = repoName;
        this.sources = sources;
        this.hasNativeImageSource = sources.stream().anyMatch(source -> source.getModules().contains((Object)ProjectKeeperModule.NATIVE_IMAGE));
    }

    @Override
    protected List<ValidationFinding> validateContent(String content) {
        ArrayList<ValidationFinding> findings = new ArrayList<ValidationFinding>();
        if (!content.contains("](dependencies.md)")) {
            findings.add(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-61").message("The project's README.md does not reference the dependencies.md file.'", new Object[0]).mitigation("Please add a link like '[Dependencies](dependencies.md)' to the README.md.", new Object[0]).toString()).build());
        }
        if (!content.contains("](doc/changes/changelog.md)")) {
            findings.add(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-64").message("The project's README.md does not reference the changelog.md file.'", new Object[0]).mitigation("Please add a link like '[Changelog](doc/changes/changelog.md)' to the changelog.md.", new Object[0]).toString()).build());
        }
        if (this.hasNativeImageSource && !content.contains(NATIVE_IMAGE_DEV_GUIDE)) {
            findings.add(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-144").message("The project's README.md does not reference the developer guide for native images.'", new Object[0]).mitigation("Please add the link: '[Developer guide for native-image projects](https://github.com/exasol/project-keeper/blob/main/doc/user_guide/preparing_a_project_for_native_image_builds.md)'.", new Object[0]).toString()).build());
        }
        if (!content.contains(this.getBadges())) {
            findings.add(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-62").message("The project's README.md does not contain a valid badges block.", new Object[0]).mitigation("Please add or replace the following badges: \n{{badge}}.", this.getBadges()).toString()).build());
        }
        return findings;
    }

    @Override
    protected String getTemplate() {
        String template = "# " + this.projectName + NL + NL + this.getBadges() + NL + NL + "## Additional Information" + NL + NL + "* [Changelog](doc/changes/changelog.md)" + NL + "* [Dependencies](dependencies.md)";
        if (this.hasNativeImageSource) {
            template = template + NL + "* [Developer guide for native-image projects](https://github.com/exasol/project-keeper/blob/main/doc/user_guide/preparing_a_project_for_native_image_builds.md)";
        }
        return template;
    }

    public String getBadges() {
        String badges = this.getBuildBadge() + NL;
        String mavenCentralBadges = this.getDeploymentBadges();
        if (!mavenCentralBadges.isBlank()) {
            badges = badges + mavenCentralBadges + NL;
        }
        badges = badges + this.getSonarCloudBadges();
        return badges;
    }

    private String getSonarCloudBadges() {
        StringBuilder badges = new StringBuilder();
        for (AnalyzedSource source : this.sources) {
            if (!(source instanceof AnalyzedMavenSource)) continue;
            this.getSonarCloudBadgeForMavenSource(badges, (AnalyzedMavenSource)source);
        }
        return badges.toString();
    }

    private void getSonarCloudBadgeForMavenSource(StringBuilder badges, AnalyzedMavenSource source) {
        if (source.isRootProject()) {
            String artifactId = source.getArtifactId();
            badges.append(this.getSonarCloudBadgesForArtifactId(artifactId));
        }
    }

    private String getSonarCloudBadgesForArtifactId(String artifactId) {
        return NL + this.sonarCloudBadge("Quality Gate Status", "alert_status", artifactId) + NL + NL + this.sonarCloudBadge("Security Rating", "security_rating", artifactId) + NL + this.sonarCloudBadge("Reliability Rating", "reliability_rating", artifactId) + NL + this.sonarCloudBadge("Maintainability Rating", "sqale_rating", artifactId) + NL + this.sonarCloudBadge("Technical Debt", "sqale_index", artifactId) + NL + NL + this.sonarCloudBadge("Code Smells", "code_smells", artifactId) + NL + this.sonarCloudBadge("Coverage", "coverage", artifactId) + NL + this.sonarCloudBadge("Duplicated Lines (%)", "duplicated_lines_density", artifactId) + NL + this.sonarCloudBadge("Lines of Code", "ncloc", artifactId);
    }

    private String getDeploymentBadges() {
        List mavenCentralSources = this.sources.stream().filter(source -> source.getModules().contains((Object)ProjectKeeperModule.MAVEN_CENTRAL) && source.isAdvertised()).collect(Collectors.toList());
        boolean hasMultipleModules = mavenCentralSources.size() > 1;
        return mavenCentralSources.stream().map(source -> this.getDeploymentBadge((AnalyzedSource)source, hasMultipleModules)).collect(Collectors.joining(", "));
    }

    private String sonarCloudBadge(String name, String metric, String artifactId) {
        return this.getBadge(name, "https://sonarcloud.io/api/project_badges/measure?project=com.exasol%3A" + artifactId + "&metric=" + metric, "https://sonarcloud.io/dashboard?id=com.exasol%3A" + artifactId);
    }

    private String getBuildBadge() {
        return this.getBadge("Build Status", "https://github.com/exasol/" + this.repoName + "/actions/workflows/ci-build.yml/badge.svg", "https://github.com/exasol/" + this.repoName + "/actions/workflows/ci-build.yml");
    }

    private String getDeploymentBadge(AnalyzedSource source, boolean withProjectName) {
        if (source instanceof AnalyzedMavenSource) {
            AnalyzedMavenSource mavenSource = (AnalyzedMavenSource)source;
            return this.getMavenCentralBadge(withProjectName, mavenSource);
        }
        throw new UnsupportedOperationException(ExaError.messageBuilder("E-PK-CORE-92").message("Project keeper does not know how to build a badge for source of type {{source type}}.", source.getClass().getName()).ticketMitigation().toString());
    }

    private String getMavenCentralBadge(boolean withProjectName, AnalyzedMavenSource mavenSource) {
        String badge = this.getBadge("Maven Central &ndash; " + mavenSource.getProjectName(), "https://img.shields.io/maven-central/v/com.exasol/" + mavenSource.getArtifactId(), "https://search.maven.org/artifact/com.exasol/" + mavenSource.getArtifactId());
        if (withProjectName) {
            return mavenSource.getProjectName() + ": " + badge;
        }
        return badge;
    }

    private String getBadge(String name, String image, String link) {
        return String.format("[![%s](%s)](%s)", name, image, link);
    }
}

