/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileName;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VersionCollector {
    private final Path projectDirectory;

    public VersionCollector(Path projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public List<ChangesFileName> collectChangesFiles() {
        List<ChangesFileName> list;
        block8: {
            Stream<Path> filesStream = Files.walk(this.projectDirectory.resolve(Path.of("doc", "changes")), new FileVisitOption[0]);
            try {
                list = filesStream.map(ChangesFileName::from).flatMap(Optional::stream).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                if (filesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (filesStream != null) {
                        try {
                            filesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-66").message("Failed to collect versions from files in folder doc/changes/.", new Object[0]).toString(), exception);
                }
            }
            filesStream.close();
        }
        return list;
    }
}

