/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.shared.repository.GitRepository;
import com.exasol.projectkeeper.shared.repository.TaggedCommit;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import com.vdurmont.semver4j.Semver;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class VersionIncrementValidator
implements Validator {
    private static final Logger LOG = Logger.getLogger(VersionIncrementValidator.class.getName());
    private final String projectVersion;
    private final GitRepository gitRepository;

    public VersionIncrementValidator(String projectVersion, Path projectDir) {
        this(projectVersion, GitRepository.open(projectDir));
    }

    VersionIncrementValidator(String projectVersion, GitRepository gitRepository) {
        this.projectVersion = projectVersion;
        this.gitRepository = gitRepository;
    }

    @Override
    public List<ValidationFinding> validate() {
        Optional<TaggedCommit> latestReleaseCommit = this.gitRepository.findLatestReleaseCommit(null);
        if (latestReleaseCommit.isEmpty()) {
            LOG.info(() -> "No git tag exists, accepting " + this.projectVersion + " as valid.");
            return Collections.emptyList();
        }
        String previousGitTag = latestReleaseCommit.get().getTag();
        if (this.isValidSuccessor(previousGitTag)) {
            return Collections.emptyList();
        }
        return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-184").message("Project version {{current version}} is not a valid successor of {{previous version}}.", this.projectVersion, previousGitTag).mitigation("Only increment one of major, minor or patch version.", new Object[0]).toString()).build());
    }

    private boolean isValidSuccessor(String previousGitTag) {
        Semver current = this.parseVersion(this.projectVersion);
        Semver previous = this.parseVersion(previousGitTag);
        return previous.nextMajor().equals(current) || previous.nextMinor().equals(current) || previous.nextPatch().equals(current);
    }

    private Semver parseVersion(String version) {
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        return new Semver(version);
    }
}

