/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileName;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import com.exasol.projectkeeper.validators.changesfile.FixedIssue;
import com.vdurmont.semver4j.Semver;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class ChangesFile {
    public static final String DEPENDENCY_UPDATES_HEADING = "## Dependency Updates";
    public static final String SUMMARY_HEADING = "## Summary";
    private final String projectName;
    private final Semver projectVersion;
    private final String releaseDate;
    private final String codeName;
    private final ChangesFileSection summarySection;
    private final List<ChangesFileSection> sections;
    private final ChangesFileSection dependencyChangeSection;

    private ChangesFile(Builder builder) {
        this.projectName = builder.projectName;
        this.projectVersion = builder.projectVersion;
        this.releaseDate = builder.releaseDate;
        this.codeName = builder.codeName;
        this.summarySection = builder.summarySection;
        this.sections = List.copyOf(builder.sections);
        this.dependencyChangeSection = builder.dependencyChangeSection;
    }

    public static Path getPathForVersion(String projectVersion) {
        return Path.of("doc", "changes", new ChangesFileName(projectVersion).filename());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ChangesFile.builder().projectName(this.projectName).projectVersion(this.projectVersion != null ? this.projectVersion.toString() : null).releaseDate(this.releaseDate).codeName(this.codeName).summary(this.summarySection).sections(List.copyOf(this.sections)).dependencyChangeSection(this.dependencyChangeSection);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Semver getProjectVersion() {
        return this.projectVersion;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public Optional<LocalDate> getParsedReleaseDate() {
        try {
            return Optional.ofNullable(this.getReleaseDate()).map(LocalDate::parse);
        }
        catch (DateTimeParseException exception) {
            return Optional.empty();
        }
    }

    public List<ChangesFileSection> getSections() {
        return this.sections;
    }

    public Optional<ChangesFileSection> getDependencyChangeSection() {
        return Optional.ofNullable(this.dependencyChangeSection);
    }

    public Optional<ChangesFileSection> getSummarySection() {
        return Optional.ofNullable(this.summarySection);
    }

    public List<FixedIssue> getFixedIssues() {
        Stream summary = this.getSummarySection().map(Stream::of).orElseGet(Stream::empty);
        return Stream.concat(summary, this.sections.stream()).flatMap(ChangesFileSection::getFixedIssues).toList();
    }

    public String toString() {
        return "ChangesFile [projectName=" + this.projectName + ", projectVersion=" + this.projectVersion + ", releaseDate=" + this.releaseDate + ", codeName=" + this.codeName + ", summarySection=" + this.summarySection + ", sections=" + this.sections + ", dependencyChangeSection=" + this.dependencyChangeSection + "]";
    }

    public int hashCode() {
        return Objects.hash(this.projectName, this.projectVersion, this.releaseDate, this.codeName, this.summarySection, this.sections, this.dependencyChangeSection);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangesFile other = (ChangesFile)obj;
        return Objects.equals(this.projectName, other.projectName) && Objects.equals(this.projectVersion, other.projectVersion) && Objects.equals(this.releaseDate, other.releaseDate) && Objects.equals(this.codeName, other.codeName) && Objects.equals(this.summarySection, other.summarySection) && Objects.equals(this.sections, other.sections) && Objects.equals(this.dependencyChangeSection, other.dependencyChangeSection);
    }

    public static class Builder {
        private String projectName;
        private Semver projectVersion;
        private String releaseDate;
        private String codeName;
        private ChangesFileSection summarySection;
        private List<ChangesFileSection> sections = new ArrayList<ChangesFileSection>();
        private ChangesFileSection dependencyChangeSection;

        private Builder() {
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder projectVersion(String projectVersion) {
            this.projectVersion = projectVersion != null ? new Semver(projectVersion) : null;
            return this;
        }

        public Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public Builder codeName(String codeName) {
            this.codeName = codeName != null && codeName.isBlank() ? null : codeName;
            return this;
        }

        public Builder addSection(ChangesFileSection section) {
            this.sections.add(section);
            return this;
        }

        public Builder summary(ChangesFileSection section) {
            if (section == null) {
                this.summarySection = null;
                return this;
            }
            if (!section.getHeading().equals(ChangesFile.SUMMARY_HEADING)) {
                throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-178").message("Dependency change section has invalid heading {{heading}}, expected {{expected heading}}", section.getHeading(), ChangesFile.SUMMARY_HEADING).ticketMitigation().toString());
            }
            this.summarySection = section;
            return this;
        }

        public Builder sections(List<ChangesFileSection> sections) {
            this.sections = List.copyOf(sections);
            return this;
        }

        public Builder dependencyChangeSection(ChangesFileSection section) {
            if (section == null) {
                this.dependencyChangeSection = null;
                return this;
            }
            if (!section.getHeading().equals(ChangesFile.DEPENDENCY_UPDATES_HEADING)) {
                throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-179").message("Dependency change section has invalid heading {{heading}}, expected {{expected heading}}", section.getHeading(), ChangesFile.DEPENDENCY_UPDATES_HEADING).ticketMitigation().toString());
            }
            this.dependencyChangeSection = section;
            return this;
        }

        public ChangesFile build() {
            return new ChangesFile(this);
        }
    }
}

